/*
 * Decompiled with CFR 0.152.
 */
package mc.euphoria_patches.euphoria_patcher.features;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import mc.euphoria_patches.euphoria_patcher.EuphoriaPatcher;
import mc.euphoria_patches.euphoria_patcher.util.EuphoriaLogger;

public class ShaderSettingsConverter {
    private static final String SETTINGS_CONVERSIONS_FILE = "settingsConversions.txt";
    private static final Map<Pattern, String> conversionRules = new HashMap<Pattern, String>();
    private static boolean initialized = false;

    private static void debugLog(String message) {
        EuphoriaLogger.debugLog("[ShaderSettingsConverter] " + message);
    }

    public static void initialize() {
        if (initialized) {
            return;
        }
        ShaderSettingsConverter.loadConversionRules();
        initialized = true;
    }

    private static void loadConversionRules() {
        try (InputStream inputStream = ShaderSettingsConverter.class.getClassLoader().getResourceAsStream(SETTINGS_CONVERSIONS_FILE);){
            if (inputStream == null) {
                ShaderSettingsConverter.debugLog("Settings conversions file not found: settingsConversions.txt");
                return;
            }
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));){
                String line;
                int lineNumber = 0;
                while ((line = reader.readLine()) != null) {
                    ++lineNumber;
                    if ((line = line.trim()).isEmpty() || line.startsWith("#")) continue;
                    String[] parts = line.split("->", 2);
                    if (parts.length < 2) {
                        ShaderSettingsConverter.debugLog("Invalid conversion rule at line " + lineNumber + ": " + line);
                        continue;
                    }
                    String from = parts[0].trim();
                    String to = parts[1].trim();
                    if (from.contains("=*")) {
                        String settingName = from.substring(0, from.indexOf("="));
                        String toSettingName = to.substring(0, to.indexOf("="));
                        from = Pattern.quote(settingName) + "=(.+)";
                        to = toSettingName + "=$1";
                    } else {
                        from = Pattern.quote(from);
                    }
                    Pattern pattern = Pattern.compile(from, 2);
                    conversionRules.put(pattern, to);
                    ShaderSettingsConverter.debugLog("Added conversion rule: " + from + " -> " + to);
                }
                ShaderSettingsConverter.debugLog("Loaded " + conversionRules.size() + " conversion rules");
            }
        }
        catch (IOException e) {
            EuphoriaPatcher.log(2, "Error loading settings conversion rules: " + e.getMessage());
        }
        catch (Exception e) {
            EuphoriaPatcher.log(2, "Unexpected error loading conversion rules: " + e.getMessage());
        }
    }

    public static String convertLine(String line) {
        String trimmedLine;
        if (!initialized) {
            ShaderSettingsConverter.initialize();
        }
        if ((trimmedLine = line.trim()).isEmpty() || trimmedLine.startsWith("#") || trimmedLine.startsWith("//")) {
            return line;
        }
        for (Map.Entry<Pattern, String> rule : conversionRules.entrySet()) {
            Matcher matcher = rule.getKey().matcher(trimmedLine);
            if (!matcher.find()) continue;
            String result = matcher.replaceAll(rule.getValue());
            ShaderSettingsConverter.debugLog("MATCH FOUND! Converted: '" + trimmedLine + "' -> '" + result + "'");
            return result;
        }
        return line;
    }

    public static List<String> convertLines(List<String> lines) {
        if (!initialized) {
            ShaderSettingsConverter.initialize();
        }
        ShaderSettingsConverter.debugLog("Starting conversion of " + lines.size() + " lines");
        int modifiedLines = 0;
        ArrayList<String> result = new ArrayList<String>(lines.size());
        for (String line : lines) {
            String converted = ShaderSettingsConverter.convertLine(line);
            if (!converted.equals(line)) {
                ++modifiedLines;
            }
            result.add(converted);
        }
        if (modifiedLines > 0) {
            ShaderSettingsConverter.debugLog("Conversion completed. Modified " + modifiedLines + " out of " + lines.size() + " lines");
        } else {
            ShaderSettingsConverter.debugLog("Conversion completed. No lines required modification");
        }
        return result;
    }
}

