/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.yungsextras.world.processor;

import com.yungnickyoung.minecraft.yungsapi.api.world.randomize.BlockStateRandomizer;
import com.yungnickyoung.minecraft.yungsextras.world.processor.INbtFeatureProcessor;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CandleBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.StairsShape;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public class SwampFeatureProcessor
implements INbtFeatureProcessor {
    private static final BlockStateRandomizer STONE_BRICK_SELECTOR = new BlockStateRandomizer(Blocks.f_50222_.m_49966_()).addBlock(Blocks.f_50223_.m_49966_(), 0.45f).addBlock(Blocks.f_50224_.m_49966_(), 0.45f);
    private static final BlockStateRandomizer STONE_BRICK_STAIRS_SELECTOR = new BlockStateRandomizer(Blocks.f_50194_.m_49966_()).addBlock(Blocks.f_50631_.m_49966_(), 0.6f);
    private static final List<Block> CANDLES = List.of(Blocks.f_152482_, Blocks.f_152483_, Blocks.f_152516_, Blocks.f_152517_, Blocks.f_152521_, Blocks.f_152522_, Blocks.f_152519_, Blocks.f_152524_);

    @Override
    public void processTemplate(StructureTemplate template, WorldGenLevel level, RandomSource randomSource, BlockPos cornerPos, BlockPos centerPos, StructurePlaceSettings placementSettings) {
        for (StructureTemplate.StructureBlockInfo blockInfo : template.m_74603_(cornerPos, placementSettings, Blocks.f_50207_)) {
            level.m_7731_(blockInfo.f_74675_(), STONE_BRICK_SELECTOR.get(randomSource), 2);
            BlockPos.MutableBlockPos mutable = blockInfo.f_74675_().m_122032_().m_122173_(Direction.DOWN);
            BlockState blockState = level.m_8055_((BlockPos)mutable);
            while (blockState.m_60795_() || blockState.m_278721_() || blockState.m_247087_()) {
                level.m_7731_((BlockPos)mutable, STONE_BRICK_SELECTOR.get(randomSource), 2);
                mutable.m_122173_(Direction.DOWN);
                blockState = level.m_8055_((BlockPos)mutable);
            }
        }
        for (StructureTemplate.StructureBlockInfo blockInfo : template.m_74603_(cornerPos, placementSettings, Blocks.f_50208_)) {
            level.m_7731_(blockInfo.f_74675_(), (BlockState)STONE_BRICK_STAIRS_SELECTOR.get(randomSource).m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)Direction.Plane.HORIZONTAL.m_235690_(randomSource)), 2);
        }
        for (StructureTemplate.StructureBlockInfo blockInfo : template.m_74603_(cornerPos, placementSettings, Blocks.f_50222_)) {
            level.m_7731_(blockInfo.f_74675_(), STONE_BRICK_SELECTOR.get(randomSource), 2);
        }
        for (StructureTemplate.StructureBlockInfo blockInfo : template.m_74603_(cornerPos, placementSettings, Blocks.f_50194_)) {
            level.m_7731_(blockInfo.f_74675_(), (BlockState)((BlockState)((BlockState)((BlockState)STONE_BRICK_STAIRS_SELECTOR.get(randomSource).m_61124_((Property)StairBlock.f_56841_, (Comparable)((Direction)blockInfo.f_74676_().m_61143_((Property)StairBlock.f_56841_)))).m_61124_((Property)StairBlock.f_56842_, (Comparable)((Half)blockInfo.f_74676_().m_61143_((Property)StairBlock.f_56842_)))).m_61124_((Property)StairBlock.f_56843_, (Comparable)((StairsShape)blockInfo.f_74676_().m_61143_((Property)StairBlock.f_56843_)))).m_61124_((Property)StairBlock.f_56844_, (Comparable)((Boolean)blockInfo.f_74676_().m_61143_((Property)StairBlock.f_56844_))), 2);
        }
        for (StructureTemplate.StructureBlockInfo blockInfo : template.m_74603_(cornerPos, placementSettings, Blocks.f_152522_)) {
            int numCandles = randomSource.m_188503_(4) + 1;
            boolean lit = randomSource.m_188501_() < 0.1f;
            level.m_7731_(blockInfo.f_74675_(), (BlockState)((BlockState)SwampFeatureProcessor.getRandomCandle(randomSource).m_49966_().m_61124_((Property)CandleBlock.f_152790_, (Comparable)Integer.valueOf(numCandles))).m_61124_((Property)CandleBlock.f_152791_, (Comparable)Boolean.valueOf(lit)), 2);
        }
    }

    private static Block getRandomCandle(RandomSource randomSource) {
        int i = randomSource.m_188503_(CANDLES.size());
        return CANDLES.get(i);
    }
}

