/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.dyenamics.data;

import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import cy.jdkdigital.dyenamics.core.init.BlockInit;
import cy.jdkdigital.dyenamics.core.init.EntityInit;
import cy.jdkdigital.dyenamics.core.util.DyenamicDyeColor;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.data.loot.EntityLootSubProvider;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.data.loot.LootTableSubProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootDataType;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.predicates.ExplosionCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import org.jetbrains.annotations.NotNull;

public class LootDataProvider
implements DataProvider {
    private final PackOutput.PathProvider pathProvider;
    private final List<LootTableProvider.SubProviderEntry> subProviders;

    public LootDataProvider(PackOutput output, List<LootTableProvider.SubProviderEntry> providers) {
        this.pathProvider = output.m_245269_(PackOutput.Target.DATA_PACK, "loot_tables");
        this.subProviders = providers;
    }

    public String m_6055_() {
        return "Dyenamics Loot Datagen";
    }

    public CompletableFuture<?> m_213708_(CachedOutput cache) {
        HashMap map = Maps.newHashMap();
        this.subProviders.forEach(providerEntry -> ((LootTableSubProvider)providerEntry.f_243941_().get()).m_245126_((resourceLocation, builder) -> {
            builder.m_287223_(resourceLocation);
            if (map.put(resourceLocation, builder.m_79165_(providerEntry.f_244144_()).m_79167_()) != null) {
                throw new IllegalStateException("Duplicate loot table " + resourceLocation);
            }
        }));
        return CompletableFuture.allOf((CompletableFuture[])map.entrySet().stream().map(entry -> DataProvider.m_253162_((CachedOutput)cache, (JsonElement)LootDataType.f_278413_.m_278857_().toJsonTree(entry.getValue()), (Path)this.pathProvider.m_245731_((ResourceLocation)entry.getKey()))).toArray(CompletableFuture[]::new));
    }

    public static class EntityLootProvider
    extends EntityLootSubProvider {
        List<EntityType<?>> knownEntities = new ArrayList();

        public EntityLootProvider() {
            super(FeatureFlags.f_244280_.m_247355_());
        }

        public void m_246942_() {
            for (DyenamicDyeColor dyenamicDyeColor : DyenamicDyeColor.dyenamicValues()) {
            }
        }

        private void addSheep(DyenamicDyeColor color) {
            Block item = (Block)BlockInit.DYED_BLOCKS.get(color.m_7912_()).get("wool").get();
            LootTable.Builder loot = LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)item)));
            this.m_245309_((EntityType)EntityInit.SHEEP.get(), loot);
        }

        protected void m_245309_(EntityType<?> pEntityType, LootTable.Builder pBuilder) {
            super.m_245309_(pEntityType, pBuilder);
            this.knownEntities.add(pEntityType);
        }

        protected Stream<EntityType<?>> getKnownEntityTypes() {
            return this.knownEntities.stream();
        }
    }

    public static class BlockProvider
    extends BlockLootSubProvider {
        private static final Map<Block, Function<Block, LootTable.Builder>> functionTable = new HashMap<Block, Function<Block, LootTable.Builder>>();
        private List<Block> knownBlocks = new ArrayList<Block>();

        public BlockProvider() {
            super(Set.of(), FeatureFlags.f_244280_.m_247355_());
        }

        protected void m_245660_() {
            for (DyenamicDyeColor color : DyenamicDyeColor.dyenamicValues()) {
                this.m_245724_((Block)BlockInit.DYED_BLOCKS.get(color.m_7912_()).get("banner").get());
                this.m_246481_((Block)BlockInit.DYED_BLOCKS.get(color.m_7912_()).get("bed").get(), block -> this.m_245178_((Block)block, (Property)BedBlock.f_49440_, (Comparable)BedPart.HEAD));
                this.m_246481_((Block)BlockInit.DYED_BLOCKS.get(color.m_7912_()).get("candle").get(), x$0 -> this.m_245895_((Block)x$0));
                this.m_247577_((Block)BlockInit.DYED_BLOCKS.get(color.m_7912_()).get("candle_cake").get(), BlockProvider.m_246838_((Block)((Block)BlockInit.DYED_BLOCKS.get(color.m_7912_()).get("candle_cake").get())));
                this.m_245724_((Block)BlockInit.DYED_BLOCKS.get(color.m_7912_()).get("carpet").get());
                this.m_245724_((Block)BlockInit.DYED_BLOCKS.get(color.m_7912_()).get("concrete").get());
                this.m_245724_((Block)BlockInit.DYED_BLOCKS.get(color.m_7912_()).get("concrete_powder").get());
                this.m_245724_((Block)BlockInit.DYED_BLOCKS.get(color.m_7912_()).get("glazed_terracotta").get());
                this.m_245724_((Block)BlockInit.DYED_BLOCKS.get(color.m_7912_()).get("rockwool").get());
                this.m_246481_((Block)BlockInit.DYED_BLOCKS.get(color.m_7912_()).get("shulker_box").get(), x$0 -> this.m_247334_((Block)x$0));
                this.m_245644_((Block)BlockInit.DYED_BLOCKS.get(color.m_7912_()).get("stained_glass").get());
                this.m_245644_((Block)BlockInit.DYED_BLOCKS.get(color.m_7912_()).get("stained_glass_pane").get());
                this.m_245724_((Block)BlockInit.DYED_BLOCKS.get(color.m_7912_()).get("terracotta").get());
                this.dropOther((Block)BlockInit.DYED_BLOCKS.get(color.m_7912_()).get("wall_banner").get(), (Block)BlockInit.DYED_BLOCKS.get(color.m_7912_()).get("banner").get());
                this.m_245724_((Block)BlockInit.DYED_BLOCKS.get(color.m_7912_()).get("wool").get());
            }
        }

        protected void m_247577_(Block block, LootTable.Builder builder) {
            super.m_247577_(block, builder);
            this.knownBlocks.add(block);
        }

        protected Iterable<Block> getKnownBlocks() {
            return this.knownBlocks;
        }

        protected void m_246481_(Block block, Function<Block, LootTable.Builder> builderFunction) {
            this.m_247577_(block, builderFunction.apply(block));
        }

        public void m_245724_(@NotNull Block block) {
            Function<Block, LootTable.Builder> func = functionTable.getOrDefault(block, BlockProvider::genOptionalBlockDrop);
            this.m_247577_(block, func.apply(block));
        }

        public void dropOther(@NotNull Block block, @NotNull Block otherBlock) {
            Function<Block, LootTable.Builder> func = functionTable.getOrDefault(block, BlockProvider::genOptionalBlockDrop);
            this.m_247577_(block, func.apply(otherBlock));
        }

        public void dropNothing(@NotNull Block block) {
            Function<Block, LootTable.Builder> func = functionTable.getOrDefault(block, BlockProvider::genBlankBlockDrop);
            this.m_247577_(block, func.apply(block));
        }

        protected static LootTable.Builder genOptionalBlockDrop(Block block) {
            LootPoolEntryContainer.Builder builder = LootItem.m_79579_((ItemLike)block).m_79080_(ExplosionCondition.m_81661_());
            return LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(builder));
        }

        protected static LootTable.Builder genBlankBlockDrop(Block block) {
            return LootTable.m_79147_();
        }
    }
}

