/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.dyenamics.common.recipes;

import com.google.common.collect.Lists;
import cy.jdkdigital.dyenamics.common.items.DyenamicDyeItem;
import cy.jdkdigital.dyenamics.core.init.RecipeSerializerInit;
import cy.jdkdigital.dyenamics.core.util.ColorUtil;
import java.util.ArrayList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.DyeableLeatherItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;

public class DyenamicArmorColoringRecipe
extends CustomRecipe {
    public DyenamicArmorColoringRecipe(ResourceLocation id, CraftingBookCategory category) {
        super(id, category);
    }

    public boolean matches(CraftingContainer pInv, Level pLevel) {
        ItemStack armorStack = ItemStack.f_41583_;
        ArrayList list = Lists.newArrayList();
        for (int i = 0; i < pInv.m_6643_(); ++i) {
            ItemStack stack = pInv.m_8020_(i);
            if (stack.m_41619_()) continue;
            if (stack.m_41720_() instanceof DyeableLeatherItem) {
                if (!armorStack.m_41619_()) {
                    return false;
                }
                armorStack = stack;
                continue;
            }
            if (stack.m_41720_() instanceof DyeItem || stack.m_41720_() instanceof DyenamicDyeItem) {
                list.add(stack);
                continue;
            }
            return false;
        }
        return !armorStack.m_41619_() && !list.isEmpty();
    }

    public ItemStack assemble(CraftingContainer pContainer, RegistryAccess pRegistryAccess) {
        ArrayList list = Lists.newArrayList();
        ItemStack armorItem = ItemStack.f_41583_;
        for (int i = 0; i < pContainer.m_6643_(); ++i) {
            ItemStack stack = pContainer.m_8020_(i);
            if (stack.m_41619_()) continue;
            Item item = stack.m_41720_();
            if (item instanceof DyeableLeatherItem) {
                if (!armorItem.m_41619_()) {
                    return ItemStack.f_41583_;
                }
                armorItem = stack.m_41777_();
                continue;
            }
            if (item instanceof DyeItem || item instanceof DyenamicDyeItem) {
                list.add(item);
                continue;
            }
            return ItemStack.f_41583_;
        }
        return !armorItem.m_41619_() && !list.isEmpty() ? ColorUtil.dyeArmor(armorItem, list) : ItemStack.f_41583_;
    }

    public boolean m_8004_(int width, int height) {
        return width * height >= 2;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)RecipeSerializerInit.ARMOR.get();
    }
}

