/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.farm_and_charm.core.network.packet;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.satisfy.farm_and_charm.core.block.entity.TextEditableBlockEntity;

public class SetTextPacket {
    private final BlockPos pos;
    private final List<String> texts;

    public SetTextPacket(BlockPos pos, List<String> texts) {
        this.pos = pos;
        this.texts = texts;
    }

    public static void encode(SetTextPacket msg, FriendlyByteBuf buf) {
        buf.m_130064_(msg.pos);
        buf.writeInt(msg.texts.size());
        for (String text : msg.texts) {
            buf.m_130070_(text);
        }
    }

    public static SetTextPacket decode(FriendlyByteBuf buf) {
        BlockPos pos = buf.m_130135_();
        int size = buf.readInt();
        ArrayList<String> texts = new ArrayList<String>();
        for (int i = 0; i < size; ++i) {
            texts.add(buf.m_130136_(50));
        }
        return new SetTextPacket(pos, texts);
    }

    public static void handle(SetTextPacket msg, ServerPlayer player) {
        BlockEntity entity;
        Level level = player.m_9236_();
        if (level.m_46749_(msg.pos) && (entity = level.m_7702_(msg.pos)) instanceof TextEditableBlockEntity) {
            TextEditableBlockEntity editable = (TextEditableBlockEntity)entity;
            int maxLines = editable.getTextLineCount();
            for (int i = 0; i < Math.min(msg.texts.size(), maxLines); ++i) {
                editable.setText(i, (Component)Component.m_237113_((String)msg.texts.get(i)));
            }
        }
    }
}

