/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.farm_and_charm.core.block.entity;

import java.util.List;
import java.util.stream.IntStream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.satisfy.farm_and_charm.core.block.MincerBlock;
import net.satisfy.farm_and_charm.core.recipe.MincerRecipe;
import net.satisfy.farm_and_charm.core.registry.EntityTypeRegistry;
import net.satisfy.farm_and_charm.core.registry.RecipeTypeRegistry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MincerBlockEntity
extends RandomizableContainerBlockEntity
implements WorldlyContainer,
BlockEntityTicker<MincerBlockEntity> {
    public final int SLOT_COUNT = 2;
    public final int INPUT_SLOT = 0;
    public final int OUTPUT_SLOT = 1;
    private NonNullList<ItemStack> stacks = NonNullList.m_122780_((int)2, (Object)ItemStack.f_41583_);

    public MincerBlockEntity(BlockPos position, BlockState state) {
        super((BlockEntityType)EntityTypeRegistry.MINCER_BLOCK_ENTITY.get(), position, state);
    }

    public static void spawnItem(Level world, ItemStack stack, int speed, Direction side, Position pos) {
        double d = pos.m_7096_();
        double e = pos.m_7098_();
        double f = pos.m_7094_();
        e = side.m_122434_() == Direction.Axis.Y ? (e -= 0.125) : (e -= 0.15625);
        ItemEntity itemEntity = new ItemEntity(world, d, e, f, stack);
        double g = world.f_46441_.m_188500_() * 0.1 + 0.2;
        itemEntity.m_20334_(world.f_46441_.m_216328_((double)side.m_122429_() * g, 0.0172275 * (double)speed), world.f_46441_.m_216328_(0.2, 0.0172275 * (double)speed), world.f_46441_.m_216328_((double)side.m_122431_() * g, 0.0172275 * (double)speed));
        world.m_7967_((Entity)itemEntity);
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        if (!this.m_59631_(compound)) {
            this.stacks = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
        }
        ContainerHelper.m_18980_((CompoundTag)compound, this.stacks);
    }

    public void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        if (!this.m_59634_(compound)) {
            ContainerHelper.m_18973_((CompoundTag)compound, this.stacks);
        }
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    @NotNull
    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    public boolean m_7983_() {
        for (ItemStack itemstack : this.stacks) {
            if (itemstack.m_41619_()) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public Component m_6820_() {
        return Component.m_237113_((String)"mincer");
    }

    @NotNull
    public AbstractContainerMenu m_6555_(int id, Inventory inventory) {
        return ChestMenu.m_39255_((int)id, (Inventory)inventory);
    }

    private void dropItemsInOutputSlot(Level level, BlockPos pos, BlockState state, MincerBlockEntity mincer) {
        Direction direction = ((Direction)state.m_61143_((Property)MincerBlock.FACING)).m_122427_();
        if (!level.m_5776_() && !((ItemStack)this.stacks.get(1)).m_41619_()) {
            ItemStack droppedStack = new ItemStack((ItemLike)((ItemStack)mincer.stacks.get(1)).m_41720_());
            droppedStack.m_41764_(((ItemStack)mincer.stacks.get(1)).m_41613_());
            this.stacks.set(1, (Object)ItemStack.f_41583_);
            Vec3 vec3d = Vec3.m_82512_((Vec3i)pos);
            Vec3 vec3d2 = vec3d.m_231075_(direction, 0.7);
            ((ServerLevel)level).m_8767_((ParticleOptions)ParticleTypes.f_123764_, vec3d2.m_7096_(), vec3d2.m_7098_(), vec3d2.m_7094_(), 3, 0.2, 0.1, 0.0, 0.1);
            MincerBlockEntity.spawnItem(level, droppedStack, 6, direction, (Position)vec3d2);
        }
    }

    public int m_6893_() {
        return 64;
    }

    public int m_6643_() {
        return this.stacks.size();
    }

    public boolean m_7013_(int index, ItemStack stack) {
        ItemStack inputSlotItemStack = (ItemStack)this.stacks.get(0);
        return index == 0 && inputSlotItemStack.m_41619_() || stack.m_150930_(inputSlotItemStack.m_41720_()) && inputSlotItemStack.m_41613_() < inputSlotItemStack.m_41741_();
    }

    @NotNull
    public ItemStack m_8020_(int index) {
        return (ItemStack)this.m_7086_().get(index);
    }

    @NotNull
    public NonNullList<ItemStack> m_7086_() {
        return this.stacks;
    }

    protected void m_6520_(NonNullList<ItemStack> stacks) {
        this.stacks = stacks;
    }

    public int @NotNull [] m_7071_(Direction side) {
        return IntStream.range(0, this.m_6643_()).toArray();
    }

    public boolean m_7155_(int index, ItemStack stack, @Nullable Direction direction) {
        return this.m_7013_(index, stack);
    }

    public boolean m_7157_(int index, ItemStack stack, Direction direction) {
        return direction == Direction.UP && this.m_7013_(index, stack);
    }

    public void tick(Level level, BlockPos pos, BlockState state, MincerBlockEntity mincer) {
        this.dropItemsInOutputSlot(level, pos, state, mincer);
        if (!level.m_5776_() && level.m_8055_(pos).m_60734_() instanceof MincerBlock) {
            int crank = (Integer)state.m_61143_((Property)MincerBlock.CRANK);
            int cranked = (Integer)state.m_61143_((Property)MincerBlock.CRANKED);
            if (crank > 0) {
                if (cranked < 20) {
                    ++cranked;
                }
                --crank;
                if (cranked >= 20) {
                    cranked = 0;
                    MincerRecipe recipe = level.m_7465_().m_44015_((RecipeType)RecipeTypeRegistry.MINCER_RECIPE_TYPE.get(), (Container)mincer, level).orElse(null);
                    if (recipe != null) {
                        ItemStack inputStack = (ItemStack)this.stacks.get(0);
                        String recipe_type = recipe.getRecipeType();
                        int recipe_difficulty = 5;
                        switch (recipe_type) {
                            case "MEAT": {
                                recipe_difficulty = 1;
                                break;
                            }
                            case "WOOD": {
                                recipe_difficulty = 2;
                                break;
                            }
                            case "STONE": {
                                recipe_difficulty = 3;
                                break;
                            }
                            case "METAL": {
                                recipe_difficulty = 4;
                            }
                        }
                        AABB searched_area = new AABB(pos);
                        searched_area.m_82400_(4.0);
                        List playersNearby = level.m_6443_(ServerPlayer.class, searched_area, LivingEntity::m_6084_);
                        if (!playersNearby.isEmpty()) {
                            for (Player player : playersNearby) {
                                if (player == null || !player.m_21206_().m_150930_(inputStack.m_41720_())) continue;
                                --recipe_difficulty;
                            }
                        }
                        if (recipe_difficulty > 0) {
                            inputStack.m_41774_(1);
                            inputStack = inputStack.m_41619_() ? ItemStack.f_41583_ : inputStack;
                            mincer.m_6836_(0, inputStack);
                            mincer.m_6836_(1, recipe.m_8043_(level.m_9598_()));
                            level.m_7731_(pos, (BlockState)((BlockState)state.m_61124_((Property)MincerBlock.CRANK, (Comparable)Integer.valueOf(crank))).m_61124_((Property)MincerBlock.CRANKED, (Comparable)Integer.valueOf(cranked)), 3);
                            return;
                        }
                    }
                }
                level.m_7731_(pos, (BlockState)((BlockState)state.m_61124_((Property)MincerBlock.CRANK, (Comparable)Integer.valueOf(crank))).m_61124_((Property)MincerBlock.CRANKED, (Comparable)Integer.valueOf(cranked)), 3);
            } else if (cranked > 0 && cranked < 20) {
                level.m_7731_(pos, (BlockState)state.m_61124_((Property)MincerBlock.CRANKED, (Comparable)Integer.valueOf(0)), 3);
            }
        }
    }
}

