/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.farm_and_charm.core.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.animal.Chicken;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.satisfy.farm_and_charm.core.block.entity.ChickenCoopBlockEntity;
import net.satisfy.farm_and_charm.core.registry.ObjectRegistry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChickenCoopBlock
extends BaseEntityBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final IntegerProperty EGGS = IntegerProperty.m_61631_((String)"eggs", (int)0, (int)3);

    public ChickenCoopBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)EGGS, (Comparable)Integer.valueOf(0)));
    }

    @NotNull
    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)ctx.m_8125_().m_122424_())).m_61124_((Property)EGGS, (Comparable)Integer.valueOf(0));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, EGGS});
    }

    public BlockEntity m_142194_(@NotNull BlockPos pos, @NotNull BlockState state) {
        return new ChickenCoopBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return level.f_46443_ ? null : (lvl, pos, st, be) -> {
            if (be instanceof ChickenCoopBlockEntity) {
                int stage;
                ChickenCoopBlockEntity coop = (ChickenCoopBlockEntity)be;
                ChickenCoopBlockEntity.tick(lvl, pos, coop);
                int eggCount = coop.getEggCount();
                int n = eggCount >= 7 ? 3 : (eggCount >= 4 ? 2 : (stage = eggCount >= 1 ? 1 : 0));
                if ((Integer)lvl.m_8055_(pos).m_61143_((Property)EGGS) != stage) {
                    lvl.m_7731_(pos, (BlockState)lvl.m_8055_(pos).m_61124_((Property)EGGS, (Comparable)Integer.valueOf(stage)), 2);
                }
            }
        };
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.m_60713_(newState.m_60734_())) {
            super.m_6810_(state, level, pos, newState, isMoving);
        }
    }

    public void m_5707_(Level level, BlockPos pos, BlockState state, Player player) {
        BlockEntity be;
        if (!level.f_46443_ && (be = level.m_7702_(pos)) instanceof ChickenCoopBlockEntity) {
            boolean hasNbt;
            ChickenCoopBlockEntity coop = (ChickenCoopBlockEntity)be;
            boolean bl = hasNbt = !coop.getStoredChickens().isEmpty() || coop.getEggCount() > 0;
            if (hasNbt || !player.m_7500_()) {
                ItemStack stack = new ItemStack((ItemLike)ObjectRegistry.CHICKEN_COOP_ITEM.get());
                if (hasNbt) {
                    CompoundTag tag = new CompoundTag();
                    coop.m_183515_(tag);
                    stack.m_41700_("BlockEntityTag", (Tag)tag);
                }
                Containers.m_18992_((Level)level, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)stack);
            }
        }
        super.m_5707_(level, pos, state, player);
    }

    @NotNull
    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockEntity be;
        if (!level.f_46443_ && (be = level.m_7702_(pos)) instanceof ChickenCoopBlockEntity) {
            ChickenCoopBlockEntity coop = (ChickenCoopBlockEntity)be;
            ItemStack heldItem = player.m_21120_(hand);
            if (heldItem.m_150930_((Item)ObjectRegistry.PITCHFORK.get()) && !coop.getStoredChickens().isEmpty()) {
                coop.releaseAllChickens();
                level.m_5594_(null, pos, SoundEvents.f_11666_, player.m_5720_(), 1.0f, 1.1f);
                level.m_5594_(null, pos, SoundEvents.f_11753_, player.m_5720_(), 0.325f, 0.825f);
                level.m_5594_(null, pos, SoundEvents.f_11696_, player.m_5720_(), 0.7f, 1.1f);
                return InteractionResult.SUCCESS;
            }
            int eggCount = coop.getEggCount();
            if (eggCount > 0) {
                player.m_36356_(Items.f_42521_.m_7968_().m_255036_(eggCount));
                coop.clearEggs();
                coop.m_6596_();
                level.m_7731_(pos, (BlockState)state.m_61124_((Property)EGGS, (Comparable)Integer.valueOf(0)), 2);
                return InteractionResult.SUCCESS;
            }
            if (coop.hasSpaceForChicken()) {
                for (Chicken chicken : level.m_45976_(Chicken.class, new AABB(pos).m_82400_(7.0))) {
                    if (!chicken.m_21523_() || chicken.m_21524_() != player || !chicken.m_6084_()) continue;
                    coop.addChicken(chicken);
                    chicken.m_21455_(true, true);
                    level.m_5594_(null, pos, SoundEvents.f_11695_, player.m_5720_(), 1.0f, 1.0f);
                    return InteractionResult.SUCCESS;
                }
            }
        }
        return InteractionResult.PASS;
    }

    @NotNull
    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return Shapes.m_83110_((VoxelShape)Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)12.0, (double)15.0), (VoxelShape)Block.m_49796_((double)0.0, (double)12.0, (double)0.0, (double)16.0, (double)14.0, (double)16.0));
    }
}

