/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.glue;

import com.simibubi.create.AllItems;
import com.simibubi.create.AllPackets;
import com.simibubi.create.api.contraption.BlockMovementChecks;
import com.simibubi.create.content.contraptions.glue.GlueEffectPacket;
import com.simibubi.create.content.contraptions.glue.SuperGlueEntity;
import java.util.HashSet;
import net.createmod.catnip.data.Iterate;
import net.createmod.catnip.levelWrappers.RayTraceLevel;
import net.createmod.catnip.placement.IPlacementHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber
public class SuperGlueHandler {
    @SubscribeEvent
    public static void glueListensForBlockPlacement(BlockEvent.EntityPlaceEvent event) {
        LevelAccessor world = event.getLevel();
        Entity entity = event.getEntity();
        BlockPos pos = event.getPos();
        if (entity == null || world == null || pos == null) {
            return;
        }
        if (world.m_5776_()) {
            return;
        }
        HashSet<SuperGlueEntity> cached = new HashSet<SuperGlueEntity>();
        for (Direction direction : Iterate.directions) {
            BlockPos relative = pos.m_121945_(direction);
            if (!SuperGlueEntity.isGlued(world, pos, direction, cached) || !BlockMovementChecks.isMovementNecessary(world.m_8055_(relative), entity.m_9236_(), relative)) continue;
            AllPackets.getChannel().send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> entity), (Object)new GlueEffectPacket(pos, direction, true));
        }
        if (entity instanceof Player) {
            SuperGlueHandler.glueInOffHandAppliesOnBlockPlace(event, pos, (Player)entity);
        }
    }

    public static void glueInOffHandAppliesOnBlockPlace(BlockEvent.EntityPlaceEvent event, BlockPos pos, Player placer) {
        ItemStack itemstack = placer.m_21206_();
        AttributeInstance reachAttribute = placer.m_21051_((Attribute)ForgeMod.BLOCK_REACH.get());
        if (!AllItems.SUPER_GLUE.isIn(itemstack) || reachAttribute == null) {
            return;
        }
        if (AllItems.WRENCH.isIn(placer.m_21205_())) {
            return;
        }
        if (event.getPlacedAgainst() == IPlacementHelper.ID) {
            return;
        }
        double distance = reachAttribute.m_22135_();
        Vec3 start = placer.m_20299_(1.0f);
        Vec3 look = placer.m_20252_(1.0f);
        Vec3 end = start.m_82520_(look.f_82479_ * distance, look.f_82480_ * distance, look.f_82481_ * distance);
        Level world = placer.m_9236_();
        RayTraceLevel rayTraceLevel = new RayTraceLevel((LevelAccessor)world, (p, state) -> p.equals((Object)pos) ? Blocks.f_50016_.m_49966_() : state);
        BlockHitResult ray = rayTraceLevel.m_45547_(new ClipContext(start, end, ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)placer));
        Direction face = ray.m_82434_();
        if (face == null || ray.m_6662_() == HitResult.Type.MISS) {
            return;
        }
        BlockPos gluePos = ray.m_82425_();
        if (!gluePos.m_121945_(face).equals((Object)pos)) {
            event.setCanceled(true);
            return;
        }
        if (SuperGlueEntity.isGlued((LevelAccessor)world, gluePos, face, null)) {
            return;
        }
        SuperGlueEntity entity = new SuperGlueEntity(world, SuperGlueEntity.span(gluePos, gluePos.m_121945_(face)));
        CompoundTag compoundnbt = itemstack.m_41783_();
        if (compoundnbt != null) {
            EntityType.m_20620_((Level)world, (Player)placer, (Entity)entity, (CompoundTag)compoundnbt);
        }
        if (SuperGlueEntity.isValidFace(world, gluePos, face)) {
            if (!world.f_46443_) {
                world.m_7967_((Entity)entity);
                AllPackets.getChannel().send(PacketDistributor.TRACKING_ENTITY.with(() -> entity), (Object)new GlueEffectPacket(gluePos, face, true));
            }
            itemstack.m_41622_(1, (LivingEntity)placer, s -> s.m_21190_(InteractionHand.OFF_HAND));
        }
    }
}

