/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import dan200.computercraft.shared.recipe.MoreCodecs;
import net.minecraft.Util;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.ItemLike;

public final class RecipeUtil {
    private RecipeUtil() {
    }

    public static NonNullList<Ingredient> readIngredients(FriendlyByteBuf buffer) {
        int count = buffer.m_130242_();
        NonNullList ingredients = NonNullList.m_122780_((int)count, (Object)Ingredient.f_43901_);
        for (int i = 0; i < ingredients.size(); ++i) {
            ingredients.set(i, (Object)Ingredient.m_43940_((FriendlyByteBuf)buffer));
        }
        return ingredients;
    }

    public static void writeIngredients(FriendlyByteBuf buffer, NonNullList<Ingredient> ingredients) {
        buffer.m_236828_(ingredients, (a, b) -> b.m_43923_(a));
    }

    public static NonNullList<Ingredient> readShapelessIngredients(JsonObject json) {
        NonNullList ingredients = NonNullList.m_122779_();
        JsonArray ingredientsList = GsonHelper.m_13933_((JsonObject)json, (String)"ingredients");
        for (int i = 0; i < ingredientsList.size(); ++i) {
            Ingredient ingredient = Ingredient.m_43917_((JsonElement)ingredientsList.get(i));
            if (ingredient.m_43947_()) continue;
            ingredients.add((Object)ingredient);
        }
        if (ingredients.isEmpty()) {
            throw new JsonParseException("No ingredients for shapeless recipe");
        }
        if (ingredients.size() > 9) {
            throw new JsonParseException("Too many ingredients for shapeless recipe the max is 9");
        }
        return ingredients;
    }

    public static ItemStack itemStackFromJson(JsonObject json) {
        Item item = ShapedRecipe.m_151278_((JsonObject)json);
        if (json.has("data")) {
            throw new JsonParseException("Disallowed data tag found");
        }
        int count = GsonHelper.m_13824_((JsonObject)json, (String)"count", (int)1);
        if (count < 1) {
            throw new JsonSyntaxException("Invalid output count: " + count);
        }
        ItemStack stack = new ItemStack((ItemLike)item, count);
        JsonElement nbt = json.get("nbt");
        if (nbt != null) {
            stack.m_41751_((CompoundTag)Util.m_260975_((DataResult)MoreCodecs.TAG.parse((DynamicOps)JsonOps.INSTANCE, (Object)nbt), JsonParseException::new));
        }
        return stack;
    }
}

