/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.command.text;

import dan200.computercraft.shared.command.text.ChatHelpers;
import dan200.computercraft.shared.command.text.TableBuilder;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import org.apache.commons.lang3.StringUtils;
import org.jspecify.annotations.Nullable;

public interface TableFormatter {
    public static final Component SEPARATOR = ChatHelpers.coloured("| ", ChatFormatting.GRAY);
    public static final Component HEADER = ChatHelpers.coloured("=", ChatFormatting.GRAY);

    public @Nullable Component getPadding(Component var1, int var2);

    public int getColumnPadding();

    public int getWidth(Component var1);

    public void writeLine(String var1, Component var2);

    default public void display(TableBuilder table) {
        int width;
        int i;
        if (table.getColumns() <= 0) {
            return;
        }
        String id = table.getId();
        int columns = table.getColumns();
        int[] maxWidths = new int[columns];
        Component[] headers = table.getHeaders();
        if (headers != null) {
            for (int i2 = 0; i2 < columns; ++i2) {
                maxWidths[i2] = this.getWidth(headers[i2]);
            }
        }
        for (Component[] row : table.getRows()) {
            for (i = 0; i < row.length; ++i) {
                width = this.getWidth(row[i]);
                if (width <= maxWidths[i]) continue;
                maxWidths[i] = width;
            }
        }
        int padding = this.getColumnPadding();
        int i22 = 0;
        while (i22 < maxWidths.length - 1) {
            int n = i22++;
            maxWidths[n] = maxWidths[n] + padding;
        }
        int totalWidth = (columns - 1) * this.getWidth(SEPARATOR);
        int[] i22 = maxWidths;
        i = i22.length;
        for (width = 0; width < i; ++width) {
            int x = i22[width];
            totalWidth += x;
        }
        if (headers != null) {
            MutableComponent line = Component.m_237113_((String)"");
            for (i = 0; i < columns - 1; ++i) {
                line.m_7220_(headers[i]);
                Component padding2 = this.getPadding(headers[i], maxWidths[i]);
                if (padding2 != null) {
                    line.m_7220_(padding2);
                }
                line.m_7220_(SEPARATOR);
            }
            line.m_7220_(headers[columns - 1]);
            this.writeLine(id, (Component)line);
            int rowCharWidth = this.getWidth(HEADER);
            int rowWidth = totalWidth / rowCharWidth + (totalWidth % rowCharWidth == 0 ? 0 : 1);
            this.writeLine(id, (Component)ChatHelpers.coloured(StringUtils.repeat((String)HEADER.getString(), (int)rowWidth), ChatFormatting.GRAY));
        }
        for (Component[] row : table.getRows()) {
            MutableComponent line = Component.m_237113_((String)"");
            for (int i3 = 0; i3 < columns - 1; ++i3) {
                line.m_7220_(row[i3]);
                Component padding3 = this.getPadding(row[i3], maxWidths[i3]);
                if (padding3 != null) {
                    line.m_7220_(padding3);
                }
                line.m_7220_(SEPARATOR);
            }
            line.m_7220_(row[columns - 1]);
            this.writeLine(id, (Component)line);
        }
        if (table.getAdditional() > 0) {
            this.writeLine(id, (Component)Component.m_237110_((String)"commands.computercraft.generic.additional_rows", (Object[])new Object[]{table.getAdditional()}).m_130940_(ChatFormatting.AQUA));
        }
    }
}

