/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.gateways.gate;

import com.google.gson.JsonObject;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.shadowsoffire.placebo.codec.PlaceboCodecs;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public record GateRules(double spawnRange, double leashRange, boolean allowDiscarding, boolean allowDimChange, boolean playerDamageOnly, boolean removeOnFailure, boolean failOnOutOfBounds, double spacing, double followRangeBoost, float defaultDropChance) {
    public static final DecimalFormat FORMAT = (DecimalFormat)Util.m_137469_((Object)new DecimalFormat("#.#"), fmt -> fmt.setDecimalFormatSymbols(DecimalFormatSymbols.getInstance(Locale.ROOT)));
    public static final Codec<GateRules> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)PlaceboCodecs.nullableField((Codec)Codec.DOUBLE, (String)"spawn_range", (Object)8.0).forGetter(GateRules::spawnRange), (App)PlaceboCodecs.nullableField((Codec)Codec.DOUBLE, (String)"leash_range", (Object)32.0).forGetter(GateRules::leashRange), (App)PlaceboCodecs.nullableField((Codec)Codec.BOOL, (String)"allow_discarding", (Object)false).forGetter(GateRules::allowDiscarding), (App)PlaceboCodecs.nullableField((Codec)Codec.BOOL, (String)"allow_dim_change", (Object)false).forGetter(GateRules::allowDimChange), (App)PlaceboCodecs.nullableField((Codec)Codec.BOOL, (String)"player_damage_only", (Object)false).forGetter(GateRules::playerDamageOnly), (App)PlaceboCodecs.nullableField((Codec)Codec.BOOL, (String)"remove_mobs_on_failure", (Object)true).forGetter(GateRules::removeOnFailure), (App)PlaceboCodecs.nullableField((Codec)Codec.BOOL, (String)"fail_on_out_of_bounds", (Object)false).forGetter(GateRules::failOnOutOfBounds), (App)PlaceboCodecs.nullableField((Codec)Codec.DOUBLE, (String)"spacing", (Object)0.0).forGetter(GateRules::spacing), (App)PlaceboCodecs.nullableField((Codec)Codec.DOUBLE, (String)"follow_range_boost", (Object)32.0).forGetter(GateRules::followRangeBoost), (App)PlaceboCodecs.nullableField((Codec)Codec.FLOAT, (String)"default_drop_chance", (Object)Float.valueOf(0.0f)).forGetter(GateRules::defaultDropChance)).apply((Applicative)inst, GateRules::new));
    public static final GateRules DEFAULT = (GateRules)((Pair)CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)new JsonObject()).get().left().get()).getFirst();

    public List<MutableComponent> buildDeviations() {
        if (DEFAULT.equals(this)) {
            return Collections.emptyList();
        }
        ArrayList<MutableComponent> list = new ArrayList<MutableComponent>();
        GateRules.append("spawn_range", list, this.spawnRange, GateRules.DEFAULT.spawnRange);
        GateRules.append("leash_range", list, this.leashRange, GateRules.DEFAULT.leashRange);
        GateRules.append("allow_discarding", list, this.allowDiscarding, GateRules.DEFAULT.allowDiscarding);
        GateRules.append("allow_dim_change", list, this.allowDimChange, GateRules.DEFAULT.allowDimChange);
        GateRules.append("player_damage_only", list, this.playerDamageOnly, GateRules.DEFAULT.playerDamageOnly);
        GateRules.append("remove_mobs_on_failure", list, this.removeOnFailure, GateRules.DEFAULT.removeOnFailure);
        GateRules.append("fail_on_out_of_bounds", list, this.failOnOutOfBounds, GateRules.DEFAULT.failOnOutOfBounds);
        GateRules.append("spacing", list, this.spacing, GateRules.DEFAULT.spacing);
        return list;
    }

    private static <T> void append(String name, List<MutableComponent> list, T val, T def) {
        if (!val.equals(def)) {
            MutableComponent comp = Component.m_237110_((String)("rule.gateways." + name), (Object[])new Object[]{GateRules.fmt(val).m_130940_(ChatFormatting.GREEN)});
            comp.m_7220_(CommonComponents.f_263701_);
            comp.m_7220_((Component)Component.m_237110_((String)"rule.gateways.default", (Object[])new Object[]{GateRules.fmt(def)}).m_130940_(ChatFormatting.DARK_GRAY));
            list.add(comp);
        }
    }

    private static MutableComponent fmt(Object val) {
        if (val instanceof Number) {
            Number n = (Number)val;
            return Component.m_237113_((String)FORMAT.format(n));
        }
        if (val instanceof Boolean) {
            Boolean b = (Boolean)val;
            return Component.m_237115_((String)("tooltip.gateways." + (b != false ? "true" : "false")));
        }
        return Component.m_237113_((String)("Unknown: " + val));
    }
}

