/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.gateways.client;

import dev.shadowsoffire.gateways.client.GatewayParticleData;
import dev.shadowsoffire.gateways.entity.GatewayEntity;
import dev.shadowsoffire.gateways.net.ParticleMessage;
import net.minecraft.client.Minecraft;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;

public class ParticleHandler {
    public static void handle(ParticleMessage msg) {
        double x = msg.x;
        double y = msg.y;
        double z = msg.z;
        int color = msg.color;
        ParticleMessage.Type type = msg.type;
        Entity src = Minecraft.m_91087_().f_91073_.m_6815_(msg.gateId);
        if (src == null) {
            return;
        }
        switch (type) {
            case IDLE: {
                GatewayParticleData data = new GatewayParticleData(color >> 16 & 0xFF, color >> 8 & 0xFF, color & 0xFF);
                RandomSource rand = src.m_9236_().f_46441_;
                for (int i = 0; i < 6; ++i) {
                    double velX = Mth.m_216263_((RandomSource)rand, (double)-0.15, (double)0.15);
                    double velY = Mth.m_216263_((RandomSource)rand, (double)-0.15, (double)0.15);
                    double velZ = Mth.m_216263_((RandomSource)rand, (double)-0.15, (double)0.15);
                    double xOff = Mth.m_216263_((RandomSource)rand, (double)-0.25, (double)0.25);
                    double yOff = Mth.m_216263_((RandomSource)rand, (double)-0.2, (double)0.2);
                    double zOff = Mth.m_216263_((RandomSource)rand, (double)-0.25, (double)0.25);
                    Minecraft.m_91087_().f_91061_.m_107370_((ParticleOptions)data, x + xOff, y + yOff, z + zOff, velX, velY, velZ);
                }
                break;
            }
            case SPAWNED: {
                GatewayParticleData data = new GatewayParticleData(color >> 16 & 0xFF, color >> 8 & 0xFF, color & 0xFF);
                RandomSource rand = src.m_9236_().f_46441_;
                for (int i = 0; i < 25; ++i) {
                    double velY = Mth.m_216263_((RandomSource)rand, (double)0.05, (double)0.35);
                    double xOff = Mth.m_216263_((RandomSource)rand, (double)-0.15, (double)0.15);
                    double yOff = Mth.m_216263_((RandomSource)rand, (double)0.05, (double)0.15);
                    double zOff = Mth.m_216263_((RandomSource)rand, (double)-0.15, (double)0.15);
                    Minecraft.m_91087_().f_91061_.m_107370_((ParticleOptions)data, x + xOff, y + yOff, z + zOff, 0.0, velY, 0.0);
                }
                break;
            }
        }
    }

    public static void spawnIdleParticles(GatewayEntity gate) {
        if (!gate.isValid()) {
            return;
        }
        Level level = gate.m_9236_();
        RandomSource rand = level.f_46441_;
        int color = gate.getGateway().color().m_131265_();
        GatewayParticleData data = new GatewayParticleData(color >> 16 & 0xFF, color >> 8 & 0xFF, color & 0xFF);
        double x = gate.m_20185_();
        double y = gate.m_20186_() + (double)(gate.m_20206_() / 2.0f);
        double z = gate.m_20189_();
        float scale = gate.getGateway().size().getScale();
        for (int i = 0; i < 30; ++i) {
            float deg = (float)((double)(i * 12) * Math.PI / 180.0);
            double velX = (double)Mth.m_14089_((float)deg) * 0.1 * (double)scale;
            double velY = Mth.m_216263_((RandomSource)rand, (double)(-0.2 * (double)scale), (double)-0.15);
            double velZ = (double)Mth.m_14031_((float)deg) * 0.1 * (double)scale;
            double xOff = velX * rand.m_188500_() * 0.2;
            double yOff = Mth.m_216263_((RandomSource)rand, (double)-0.1, (double)0.2);
            double zOff = velZ * rand.m_188500_() * 0.2;
            if (!((double)rand.m_188501_() < 0.35)) continue;
            Minecraft.m_91087_().f_91061_.m_107370_((ParticleOptions)data, x + xOff, y + yOff, z + zOff, velX, velY, velZ);
        }
    }
}

