/*
 * Decompiled with CFR 0.152.
 */
package com.satherov.luminax.datagen.data;

import com.satherov.luminax.content.BlockSet;
import com.satherov.luminax.content.LuminaxRegistry;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraftforge.common.Tags;

public class LuminaxRecipeProvider
extends RecipeProvider {
    private static final Map<Item, TagKey<Item>> colors = new HashMap<Item, TagKey<Item>>();

    public LuminaxRecipeProvider(PackOutput output) {
        super(output);
    }

    private ShapedRecipeBuilder tint(TagKey<Item> item, TagKey<Item> color, Item output) {
        return ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.MISC, (ItemLike)output, (int)8).m_126130_("aaa").m_126130_("aba").m_126130_("aaa").m_206416_(Character.valueOf('a'), item).m_206416_(Character.valueOf('b'), color).m_126132_(String.format("has_%s", item.f_203868_()), (CriterionTriggerInstance)LuminaxRecipeProvider.m_206406_(item));
    }

    private ShapedRecipeBuilder block(TagKey<Item> color, Item output) {
        return ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.MISC, (ItemLike)output, (int)4).m_126130_("aga").m_126130_("gbg").m_126130_("aga").m_126127_(Character.valueOf('a'), (ItemLike)Items.f_41905_).m_206416_(Character.valueOf('b'), color).m_206416_(Character.valueOf('g'), Tags.Items.DUSTS_GLOWSTONE).m_126132_("has_stone", (CriterionTriggerInstance)LuminaxRecipeProvider.m_125977_((ItemLike)Items.f_41905_));
    }

    private ShapedRecipeBuilder dimBlock(TagKey<Item> color, Item output) {
        return ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.MISC, (ItemLike)output, (int)4).m_126130_("awa").m_126130_("wbw").m_126130_("awa").m_126127_(Character.valueOf('a'), (ItemLike)Items.f_41905_).m_206416_(Character.valueOf('b'), color).m_126127_(Character.valueOf('w'), (ItemLike)Blocks.f_50041_).m_126132_("has_stone", (CriterionTriggerInstance)LuminaxRecipeProvider.m_125977_((ItemLike)Items.f_41905_));
    }

    private ShapedRecipeBuilder slab(Item item, Item output) {
        return ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.MISC, (ItemLike)output, (int)6).m_126130_("aaa").m_126127_(Character.valueOf('a'), (ItemLike)item).m_126132_(String.format("has_%s", LuminaxRecipeProvider.m_176632_((ItemLike)item)), (CriterionTriggerInstance)LuminaxRecipeProvider.m_125977_((ItemLike)item));
    }

    private ShapedRecipeBuilder stair(Item item, Item output) {
        return ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.MISC, (ItemLike)output, (int)4).m_126130_("a  ").m_126130_("aa ").m_126130_("aaa").m_126127_(Character.valueOf('a'), (ItemLike)item).m_126132_(String.format("has_%s", LuminaxRecipeProvider.m_176632_((ItemLike)item)), (CriterionTriggerInstance)LuminaxRecipeProvider.m_125977_((ItemLike)item));
    }

    private ShapedRecipeBuilder wall(Item item, Item output) {
        return ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.MISC, (ItemLike)output, (int)6).m_126130_("aaa").m_126130_("aaa").m_126127_(Character.valueOf('a'), (ItemLike)item).m_126132_(String.format("has_%s", LuminaxRecipeProvider.m_176632_((ItemLike)item)), (CriterionTriggerInstance)LuminaxRecipeProvider.m_125977_((ItemLike)item));
    }

    private ShapedRecipeBuilder pressurePlate(Item item, Item output) {
        return ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.MISC, (ItemLike)output, (int)1).m_126130_("aa").m_126127_(Character.valueOf('a'), (ItemLike)item).m_126132_(String.format("has_%s", LuminaxRecipeProvider.m_176632_((ItemLike)item)), (CriterionTriggerInstance)LuminaxRecipeProvider.m_125977_((ItemLike)item));
    }

    private ShapelessRecipeBuilder button(Item item, Item output) {
        return ShapelessRecipeBuilder.m_245498_((RecipeCategory)RecipeCategory.MISC, (ItemLike)output).m_126209_((ItemLike)item).m_126132_(String.format("has_%s", LuminaxRecipeProvider.m_176632_((ItemLike)item)), (CriterionTriggerInstance)LuminaxRecipeProvider.m_125977_((ItemLike)item));
    }

    protected void m_245200_(Consumer<FinishedRecipe> recipeOutput) {
        BlockSet.apply(set -> {
            this.tint(LuminaxRegistry.ITEMTAG_BLOCK, colors.get(((Block)set.BLOCK.get()).m_5456_()), ((Block)set.BLOCK.get()).m_5456_()).m_176500_(recipeOutput, "tint_" + set.BLOCK.getId().m_135815_());
            this.block(colors.get(((Block)set.BLOCK.get()).m_5456_()), ((Block)set.BLOCK.get()).m_5456_()).m_176498_(recipeOutput);
            this.slab(((Block)set.BLOCK.get()).m_5456_(), ((SlabBlock)set.SLAB.get()).m_5456_()).m_176498_(recipeOutput);
            this.stair(((Block)set.BLOCK.get()).m_5456_(), ((StairBlock)set.STAIRS.get()).m_5456_()).m_176498_(recipeOutput);
            this.wall(((Block)set.BLOCK.get()).m_5456_(), ((WallBlock)set.WALL.get()).m_5456_()).m_176498_(recipeOutput);
            this.pressurePlate(((Block)set.BLOCK.get()).m_5456_(), ((PressurePlateBlock)set.PRESSURE_PLATE.get()).m_5456_()).m_176498_(recipeOutput);
            this.button(((Block)set.BLOCK.get()).m_5456_(), ((ButtonBlock)set.BUTTON.get()).m_5456_()).m_176498_(recipeOutput);
            this.tint(LuminaxRegistry.ITEMTAG_DIM_BLOCK, colors.get(((Block)set.BLOCK.get()).m_5456_()), ((Block)set.DIM_BLOCK.get()).m_5456_()).m_176500_(recipeOutput, "tint_" + set.DIM_BLOCK.getId().m_135815_());
            this.dimBlock(colors.get(((Block)set.BLOCK.get()).m_5456_()), ((Block)set.DIM_BLOCK.get()).m_5456_()).m_176498_(recipeOutput);
            this.slab(((Block)set.DIM_BLOCK.get()).m_5456_(), ((SlabBlock)set.DIM_SLAB.get()).m_5456_()).m_176498_(recipeOutput);
            this.stair(((Block)set.DIM_BLOCK.get()).m_5456_(), ((StairBlock)set.DIM_STAIRS.get()).m_5456_()).m_176498_(recipeOutput);
            this.wall(((Block)set.DIM_BLOCK.get()).m_5456_(), ((WallBlock)set.DIM_WALL.get()).m_5456_()).m_176498_(recipeOutput);
            this.pressurePlate(((Block)set.DIM_BLOCK.get()).m_5456_(), ((PressurePlateBlock)set.DIM_PRESSURE_PLATE.get()).m_5456_()).m_176498_(recipeOutput);
            this.button(((Block)set.DIM_BLOCK.get()).m_5456_(), ((ButtonBlock)set.DIM_BUTTON.get()).m_5456_()).m_176498_(recipeOutput);
        });
    }

    static {
        colors.put(((Block)LuminaxRegistry.WHITE.BLOCK.get()).m_5456_(), (TagKey<Item>)Tags.Items.DYES_WHITE);
        colors.put(((Block)LuminaxRegistry.LIGHT_GRAY.BLOCK.get()).m_5456_(), (TagKey<Item>)Tags.Items.DYES_LIGHT_GRAY);
        colors.put(((Block)LuminaxRegistry.GRAY.BLOCK.get()).m_5456_(), (TagKey<Item>)Tags.Items.DYES_GRAY);
        colors.put(((Block)LuminaxRegistry.BLACK.BLOCK.get()).m_5456_(), (TagKey<Item>)Tags.Items.DYES_BLACK);
        colors.put(((Block)LuminaxRegistry.BROWN.BLOCK.get()).m_5456_(), (TagKey<Item>)Tags.Items.DYES_BROWN);
        colors.put(((Block)LuminaxRegistry.RED.BLOCK.get()).m_5456_(), (TagKey<Item>)Tags.Items.DYES_RED);
        colors.put(((Block)LuminaxRegistry.ORANGE.BLOCK.get()).m_5456_(), (TagKey<Item>)Tags.Items.DYES_ORANGE);
        colors.put(((Block)LuminaxRegistry.YELLOW.BLOCK.get()).m_5456_(), (TagKey<Item>)Tags.Items.DYES_YELLOW);
        colors.put(((Block)LuminaxRegistry.LIME.BLOCK.get()).m_5456_(), (TagKey<Item>)Tags.Items.DYES_LIME);
        colors.put(((Block)LuminaxRegistry.GREEN.BLOCK.get()).m_5456_(), (TagKey<Item>)Tags.Items.DYES_GREEN);
        colors.put(((Block)LuminaxRegistry.LIGHT_BLUE.BLOCK.get()).m_5456_(), (TagKey<Item>)Tags.Items.DYES_LIGHT_BLUE);
        colors.put(((Block)LuminaxRegistry.CYAN.BLOCK.get()).m_5456_(), (TagKey<Item>)Tags.Items.DYES_CYAN);
        colors.put(((Block)LuminaxRegistry.BLUE.BLOCK.get()).m_5456_(), (TagKey<Item>)Tags.Items.DYES_BLUE);
        colors.put(((Block)LuminaxRegistry.PURPLE.BLOCK.get()).m_5456_(), (TagKey<Item>)Tags.Items.DYES_PURPLE);
        colors.put(((Block)LuminaxRegistry.MAGENTA.BLOCK.get()).m_5456_(), (TagKey<Item>)Tags.Items.DYES_MAGENTA);
        colors.put(((Block)LuminaxRegistry.PINK.BLOCK.get()).m_5456_(), (TagKey<Item>)Tags.Items.DYES_PINK);
    }
}

