/*
 * Decompiled with CFR 0.152.
 */
package com.satherov.luminax.datagen.assets;

import com.satherov.luminax.content.BlockSet;
import java.util.Map;
import net.minecraft.core.Direction;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.level.block.state.properties.StairsShape;
import net.minecraft.world.level.block.state.properties.WallSide;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.MultiPartBlockStateBuilder;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.RegistryObject;

public class LuminaxBlockStateProvider
extends BlockStateProvider {
    public LuminaxBlockStateProvider(DataGenerator generator, ExistingFileHelper fileHelper) {
        super(generator.getPackOutput(), "luminax", fileHelper);
    }

    protected void registerStatesAndModels() {
        BlockSet.apply(set -> {
            this.simpleBlock((Block)set.BLOCK.get(), this.getExistingFile(set.BLOCK.getId().m_135815_()));
            this.slabBlock(set.SLAB, set.BLOCK);
            this.stairsBlock(set.STAIRS);
            this.buttonBlock(set.BUTTON);
            this.pressurePlateBlock(set.PRESSURE_PLATE);
            this.wallBlock(set.WALL);
            this.simpleBlock((Block)set.DIM_BLOCK.get(), this.getExistingFile(set.DIM_BLOCK.getId().m_135815_()));
            this.slabBlock(set.DIM_SLAB, set.DIM_BLOCK);
            this.stairsBlock(set.DIM_STAIRS);
            this.buttonBlock(set.DIM_BUTTON);
            this.pressurePlateBlock(set.DIM_PRESSURE_PLATE);
            this.wallBlock(set.DIM_WALL);
        });
    }

    private ResourceLocation block(RegistryObject<? extends Block> block) {
        return this.modLoc("block/" + block.getId().m_135815_());
    }

    private ModelFile getExistingFile(String path) {
        return this.models().getExistingFile(new ResourceLocation("luminax", path));
    }

    public void slabBlock(RegistryObject<? extends SlabBlock> slab, RegistryObject<? extends Block> block) {
        this.getVariantBuilder((Block)slab.get()).partialState().with((Property)SlabBlock.f_56353_, (Comparable)SlabType.BOTTOM).addModels(new ConfiguredModel[]{new ConfiguredModel(this.getExistingFile(slab.getId().m_135815_()))}).partialState().with((Property)SlabBlock.f_56353_, (Comparable)SlabType.TOP).addModels(new ConfiguredModel[]{new ConfiguredModel(this.getExistingFile(slab.getId().m_135815_() + "_top"))}).partialState().with((Property)SlabBlock.f_56353_, (Comparable)SlabType.DOUBLE).addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)this.models().getExistingFile(this.block(block)))});
    }

    public void stairsBlock(RegistryObject<? extends StairBlock> stair) {
        this.getVariantBuilder((Block)stair.get()).forAllStatesExcept(state -> {
            Direction facing = (Direction)state.m_61143_((Property)StairBlock.f_56841_);
            Half half = (Half)state.m_61143_((Property)StairBlock.f_56842_);
            StairsShape shape = (StairsShape)state.m_61143_((Property)StairBlock.f_56843_);
            int yRot = (int)facing.m_122427_().m_122435_();
            if (shape == StairsShape.INNER_LEFT || shape == StairsShape.OUTER_LEFT) {
                yRot += 270;
            }
            if (shape != StairsShape.STRAIGHT && half == Half.TOP) {
                yRot += 90;
            }
            boolean uvlock = (yRot %= 360) != 0 || half == Half.TOP;
            return ConfiguredModel.builder().modelFile(shape == StairsShape.STRAIGHT ? this.getExistingFile(stair.getId().m_135815_()) : (shape != StairsShape.INNER_LEFT && shape != StairsShape.INNER_RIGHT ? this.getExistingFile(stair.getId().m_135815_() + "_outer") : this.getExistingFile(stair.getId().m_135815_() + "_inner"))).rotationX(half == Half.BOTTOM ? 0 : 180).rotationY(yRot).uvLock(uvlock).build();
        }, new Property[]{StairBlock.f_56844_});
    }

    public void buttonBlock(RegistryObject<? extends ButtonBlock> button) {
        this.getVariantBuilder((Block)button.get()).forAllStates(state -> {
            Direction facing = (Direction)state.m_61143_((Property)ButtonBlock.f_54117_);
            AttachFace face = (AttachFace)state.m_61143_((Property)ButtonBlock.f_53179_);
            boolean powered = (Boolean)state.m_61143_((Property)ButtonBlock.f_51045_);
            return ConfiguredModel.builder().modelFile(powered ? this.getExistingFile(button.getId().m_135815_() + "_pressed") : this.getExistingFile(button.getId().m_135815_())).rotationX(face == AttachFace.FLOOR ? 0 : (face == AttachFace.WALL ? 90 : 180)).rotationY((int)(face == AttachFace.CEILING ? facing : facing.m_122424_()).m_122435_()).uvLock(face == AttachFace.WALL).build();
        });
    }

    public void pressurePlateBlock(RegistryObject<? extends PressurePlateBlock> pressurePlate) {
        this.getVariantBuilder((Block)pressurePlate.get()).partialState().with((Property)PressurePlateBlock.f_55249_, (Comparable)Boolean.valueOf(true)).addModels(new ConfiguredModel[]{new ConfiguredModel(this.getExistingFile(pressurePlate.getId().m_135815_() + "_down"))}).partialState().with((Property)PressurePlateBlock.f_55249_, (Comparable)Boolean.valueOf(false)).addModels(new ConfiguredModel[]{new ConfiguredModel(this.getExistingFile(pressurePlate.getId().m_135815_()))});
    }

    public void wallBlock(RegistryObject<? extends WallBlock> wall) {
        MultiPartBlockStateBuilder builder = ((MultiPartBlockStateBuilder.PartBuilder)this.getMultipartBuilder((Block)wall.get()).part().modelFile(this.getExistingFile(wall.getId().m_135815_() + "_post")).addModel()).condition((Property)WallBlock.f_57949_, (Comparable[])new Boolean[]{true}).end();
        WALL_PROPS.entrySet().stream().filter(e -> ((Direction)e.getKey()).m_122434_().m_122479_()).forEach(e -> {
            this.wallSidePart(builder, this.getExistingFile(wall.getId().m_135815_() + "_side"), (Map.Entry<Direction, Property<WallSide>>)e, WallSide.LOW);
            this.wallSidePart(builder, this.getExistingFile(wall.getId().m_135815_() + "_side_tall"), (Map.Entry<Direction, Property<WallSide>>)e, WallSide.TALL);
        });
    }

    private void wallSidePart(MultiPartBlockStateBuilder builder, ModelFile model, Map.Entry<Direction, Property<WallSide>> entry, WallSide height) {
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile(model).rotationY(((int)entry.getKey().m_122435_() + 180) % 360).uvLock(true).addModel()).condition(entry.getValue(), (Comparable[])new WallSide[]{height});
    }
}

