/*
 * Decompiled with CFR 0.152.
 */
package com.satherov.luminax.datagen.assets;

import com.satherov.luminax.content.BlockSet;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraftforge.client.model.generators.BlockModelProvider;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.RegistryObject;

public class LuminaxBlockModelProvider
extends BlockModelProvider {
    public LuminaxBlockModelProvider(PackOutput output, ExistingFileHelper existingFileHelper) {
        super(output, "luminax", existingFileHelper);
    }

    protected void registerModels() {
        BlockSet.apply(set -> {
            this.blockModel(set.BLOCK);
            this.slabModel(set.SLAB, set.BLOCK);
            this.stairModel(set.STAIRS, set.BLOCK);
            this.buttonModel(set.BUTTON, set.BLOCK);
            this.pressurePlateModel(set.PRESSURE_PLATE, set.BLOCK);
            this.wallModel(set.WALL, set.BLOCK);
            this.blockModel(set.DIM_BLOCK, set.BLOCK);
            this.slabModel(set.DIM_SLAB, set.BLOCK);
            this.stairModel(set.DIM_STAIRS, set.BLOCK);
            this.buttonModel(set.DIM_BUTTON, set.BLOCK);
            this.pressurePlateModel(set.DIM_PRESSURE_PLATE, set.BLOCK);
            this.wallModel(set.DIM_WALL, set.BLOCK);
        });
    }

    private ResourceLocation block(RegistryObject<? extends Block> block) {
        return this.modLoc("block/" + block.getId().m_135815_());
    }

    private void blockModel(RegistryObject<? extends Block> block) {
        this.singleTexture("block/" + block.getId().m_135815_(), new ResourceLocation("luminax", "block/no_shade_block"), "texture", this.block(block));
    }

    private void blockModel(RegistryObject<? extends Block> block, RegistryObject<? extends Block> block2) {
        this.singleTexture("block/" + block.getId().m_135815_(), new ResourceLocation("luminax", "block/no_shade_block"), "texture", this.block(block2));
    }

    private void slabModel(RegistryObject<? extends SlabBlock> slab, RegistryObject<? extends Block> block) {
        this.singleTexture("block/" + slab.getId().m_135815_(), new ResourceLocation("luminax", "block/no_shade_slab"), "texture", this.block(block));
        this.singleTexture("block/" + slab.getId().m_135815_() + "_top", new ResourceLocation("luminax", "block/no_shade_slab_top"), "texture", this.block(block));
    }

    private void stairModel(RegistryObject<? extends StairBlock> stair, RegistryObject<? extends Block> block) {
        this.singleTexture("block/" + stair.getId().m_135815_(), new ResourceLocation("luminax", "block/no_shade_stair"), "texture", this.block(block));
        this.singleTexture("block/" + stair.getId().m_135815_() + "_inner", new ResourceLocation("luminax", "block/no_shade_inner_stair"), "texture", this.block(block));
        this.singleTexture("block/" + stair.getId().m_135815_() + "_outer", new ResourceLocation("luminax", "block/no_shade_outer_stair"), "texture", this.block(block));
    }

    private void buttonModel(RegistryObject<? extends ButtonBlock> button, RegistryObject<? extends Block> block) {
        this.singleTexture("block/" + button.getId().m_135815_(), new ResourceLocation("luminax", "block/no_shade_button"), "texture", this.block(block));
        this.singleTexture("block/" + button.getId().m_135815_() + "_pressed", new ResourceLocation("luminax", "block/no_shade_button_pressed"), this.block(block));
        this.singleTexture("block/" + button.getId().m_135815_() + "_inventory", new ResourceLocation("luminax", "block/no_shade_button_inventory"), "texture", this.block(block));
    }

    private void pressurePlateModel(RegistryObject<? extends PressurePlateBlock> pressurePlate, RegistryObject<? extends Block> block) {
        this.singleTexture("block/" + pressurePlate.getId().m_135815_(), new ResourceLocation("luminax", "block/no_shade_pressure_plate_up"), "texture", this.block(block));
        this.singleTexture("block/" + pressurePlate.getId().m_135815_() + "_down", new ResourceLocation("luminax", "block/no_shade_pressure_plate_down"), "texture", this.block(block));
    }

    private void wallModel(RegistryObject<? extends WallBlock> wall, RegistryObject<? extends Block> block) {
        this.singleTexture("block/" + wall.getId().m_135815_(), new ResourceLocation("luminax", "block/no_shade_wall_inventory"), "texture", this.block(block));
        this.singleTexture("block/" + wall.getId().m_135815_() + "_post", new ResourceLocation("luminax", "block/no_shade_wall_post"), "texture", this.block(block));
        this.singleTexture("block/" + wall.getId().m_135815_() + "_side", new ResourceLocation("luminax", "block/no_shade_wall_side"), "texture", this.block(block));
        this.singleTexture("block/" + wall.getId().m_135815_() + "_side_tall", new ResourceLocation("luminax", "block/no_shade_wall_side_tall"), "texture", this.block(block));
    }
}

