/*
 * Decompiled with CFR 0.152.
 */
package com.satherov.luminax.datagen;

import com.satherov.luminax.datagen.LuminaxDataProvider;
import com.satherov.luminax.datagen.assets.LuminaxBlockModelProvider;
import com.satherov.luminax.datagen.assets.LuminaxBlockStateProvider;
import com.satherov.luminax.datagen.assets.LuminaxItemModelProvider;
import com.satherov.luminax.datagen.assets.lang.EN_USProvider;
import com.satherov.luminax.datagen.data.LuminaxLootTableProvider;
import com.satherov.luminax.datagen.data.LuminaxRecipeProvider;
import com.satherov.luminax.datagen.data.tags.LuminaxBlockTagProvider;
import com.satherov.luminax.datagen.data.tags.LuminaxItemTagProvider;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.Util;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.data.registries.VanillaRegistries;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="luminax", bus=Mod.EventBusSubscriber.Bus.MOD)
public class LuminaxDataGenerators {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        ExistingFileHelper fileHelper = event.getExistingFileHelper();
        CompletableFuture<HolderLookup.Provider> lookupProvider = CompletableFuture.supplyAsync(VanillaRegistries::m_255371_, Util.m_183991_());
        LuminaxDataProvider provider = new LuminaxDataProvider();
        provider.addSubProvider(event.includeClient(), (DataProvider)new LuminaxBlockModelProvider(packOutput, fileHelper));
        provider.addSubProvider(event.includeClient(), (DataProvider)new LuminaxBlockStateProvider(generator, fileHelper));
        provider.addSubProvider(event.includeClient(), (DataProvider)new LuminaxItemModelProvider(packOutput, fileHelper));
        provider.addSubProvider(event.includeClient(), (DataProvider)new EN_USProvider(packOutput));
        LuminaxBlockTagProvider blockTags = new LuminaxBlockTagProvider(packOutput, lookupProvider, fileHelper);
        provider.addSubProvider(event.includeServer(), (DataProvider)blockTags);
        provider.addSubProvider(event.includeServer(), (DataProvider)new LuminaxItemTagProvider(packOutput, lookupProvider, blockTags.m_274426_()));
        provider.addSubProvider(event.includeServer(), (DataProvider)new LuminaxRecipeProvider(packOutput));
        provider.addSubProvider(event.includeServer(), (DataProvider)new LootTableProvider(packOutput, Collections.emptySet(), List.of(new LootTableProvider.SubProviderEntry(LuminaxLootTableProvider::new, LootContextParamSets.f_81421_))));
        generator.addProvider(true, (DataProvider)provider);
    }
}

