/*
 * Decompiled with CFR 0.152.
 */
package com.satherov.luminax.content;

import com.satherov.luminax.content.LuminaxRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraftforge.registries.RegistryObject;

public class BlockSet {
    public final String name;
    private static final List<BlockSet> instances = new ArrayList<BlockSet>();
    public final RegistryObject<Block> BLOCK;
    public final RegistryObject<StairBlock> STAIRS;
    public final RegistryObject<SlabBlock> SLAB;
    public final RegistryObject<WallBlock> WALL;
    public final RegistryObject<PressurePlateBlock> PRESSURE_PLATE;
    public final RegistryObject<ButtonBlock> BUTTON;
    public final RegistryObject<Block> DIM_BLOCK;
    public final RegistryObject<StairBlock> DIM_STAIRS;
    public final RegistryObject<SlabBlock> DIM_SLAB;
    public final RegistryObject<WallBlock> DIM_WALL;
    public final RegistryObject<PressurePlateBlock> DIM_PRESSURE_PLATE;
    public final RegistryObject<ButtonBlock> DIM_BUTTON;

    public static List<BlockSet> getSets() {
        return instances;
    }

    public BlockSet(String name) {
        this.name = name;
        instances.add(this);
        this.BLOCK = BlockSet.register(String.format("%s_luminax_block", name), () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50069_).m_60953_(state -> 15)));
        this.STAIRS = BlockSet.register(String.format("%s_luminax_stairs", name), () -> new StairBlock(((Block)this.BLOCK.get()).m_49966_(), BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50635_).m_60953_(state -> 15)));
        this.SLAB = BlockSet.register(String.format("%s_luminax_slab", name), () -> new SlabBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50404_).m_60953_(state -> 15)));
        this.WALL = BlockSet.register(String.format("%s_luminax_wall", name), () -> new WallBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50609_).m_60953_(state -> 15)));
        this.PRESSURE_PLATE = BlockSet.register(String.format("%s_luminax_pressure_plate", name), () -> new PressurePlateBlock(PressurePlateBlock.Sensitivity.EVERYTHING, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50165_).m_60953_(state -> 15), BlockSetType.f_271479_));
        this.BUTTON = BlockSet.register(String.format("%s_luminax_button", name), () -> new ButtonBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50124_).m_60953_(state -> 15), BlockSetType.f_271479_, 20, true));
        this.DIM_BLOCK = BlockSet.register(String.format("dim_%s_luminax_block", name), () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50069_)));
        this.DIM_STAIRS = BlockSet.register(String.format("dim_%s_luminax_stairs", name), () -> new StairBlock(((Block)this.BLOCK.get()).m_49966_(), BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50635_)));
        this.DIM_SLAB = BlockSet.register(String.format("dim_%s_luminax_slab", name), () -> new SlabBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50404_)));
        this.DIM_WALL = BlockSet.register(String.format("dim_%s_luminax_wall", name), () -> new WallBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50609_)));
        this.DIM_PRESSURE_PLATE = BlockSet.register(String.format("dim_%s_luminax_pressure_plate", name), () -> new PressurePlateBlock(PressurePlateBlock.Sensitivity.EVERYTHING, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50165_), BlockSetType.f_271479_));
        this.DIM_BUTTON = BlockSet.register(String.format("dim_%s_luminax_button", name), () -> new ButtonBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50124_), BlockSetType.f_271479_, 20, true));
    }

    public static void apply(Consumer<BlockSet> consumer) {
        BlockSet.getSets().forEach(consumer);
    }

    private static <T extends Block> RegistryObject<T> register(String name, Supplier<T> properties) {
        RegistryObject block = LuminaxRegistry.BLOCKS.register(name, properties);
        LuminaxRegistry.ITEMS.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties()));
        return block;
    }
}

