/*
 * Decompiled with CFR 0.152.
 */
package com.satherov.luminax;

import com.mojang.logging.LogUtils;
import com.satherov.luminax.content.BlockSet;
import com.satherov.luminax.content.LuminaxRegistry;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLConstructModEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistry;
import org.slf4j.Logger;

@Mod(value="luminax")
public class Luminax {
    public static final String MOD_ID = "luminax";
    private static final Logger LOGGER = LogUtils.getLogger();

    public static ResourceLocation prefix(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)path);
    }

    public Luminax() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        LuminaxRegistry.CREATIVE_TABS.register(modEventBus);
        LuminaxRegistry.BLOCKS.register(modEventBus);
        LuminaxRegistry.ITEMS.register(modEventBus);
    }

    @Mod.EventBusSubscriber(modid="luminax", bus=Mod.EventBusSubscriber.Bus.MOD)
    private static class DataFixer {
        private DataFixer() {
        }

        @SubscribeEvent
        public static void registerAliases(FMLConstructModEvent event) {
            BlockSet.apply(set -> {
                ((ForgeRegistry)ForgeRegistries.ITEMS).addAlias(Luminax.prefix(String.format("%s_block", set.name)), set.BLOCK.getId());
                ((ForgeRegistry)ForgeRegistries.ITEMS).addAlias(Luminax.prefix(String.format("%s_slab", set.name)), set.SLAB.getId());
                ((ForgeRegistry)ForgeRegistries.ITEMS).addAlias(Luminax.prefix(String.format("%s_stairs", set.name)), set.STAIRS.getId());
                ((ForgeRegistry)ForgeRegistries.ITEMS).addAlias(Luminax.prefix(String.format("%s_wall", set.name)), set.WALL.getId());
                ((ForgeRegistry)ForgeRegistries.ITEMS).addAlias(Luminax.prefix(String.format("%s_pressure_plate", set.name)), set.PRESSURE_PLATE.getId());
                ((ForgeRegistry)ForgeRegistries.ITEMS).addAlias(Luminax.prefix(String.format("%s_button", set.name)), set.BUTTON.getId());
                ((ForgeRegistry)ForgeRegistries.ITEMS).addAlias(Luminax.prefix(String.format("%s_dim_block", set.name)), set.DIM_BLOCK.getId());
                ((ForgeRegistry)ForgeRegistries.ITEMS).addAlias(Luminax.prefix(String.format("%s_dim_slab", set.name)), set.DIM_SLAB.getId());
                ((ForgeRegistry)ForgeRegistries.ITEMS).addAlias(Luminax.prefix(String.format("%s_dim_stairs", set.name)), set.DIM_STAIRS.getId());
                ((ForgeRegistry)ForgeRegistries.ITEMS).addAlias(Luminax.prefix(String.format("%s_dim_wall", set.name)), set.DIM_WALL.getId());
                ((ForgeRegistry)ForgeRegistries.ITEMS).addAlias(Luminax.prefix(String.format("%s_dim_pressure_plate", set.name)), set.DIM_PRESSURE_PLATE.getId());
                ((ForgeRegistry)ForgeRegistries.ITEMS).addAlias(Luminax.prefix(String.format("%s_dim_button", set.name)), set.DIM_BUTTON.getId());
                ((ForgeRegistry)ForgeRegistries.BLOCKS).addAlias(Luminax.prefix(String.format("%s_block", set.name)), set.BLOCK.getId());
                ((ForgeRegistry)ForgeRegistries.BLOCKS).addAlias(Luminax.prefix(String.format("%s_slab", set.name)), set.SLAB.getId());
                ((ForgeRegistry)ForgeRegistries.BLOCKS).addAlias(Luminax.prefix(String.format("%s_stairs", set.name)), set.STAIRS.getId());
                ((ForgeRegistry)ForgeRegistries.BLOCKS).addAlias(Luminax.prefix(String.format("%s_wall", set.name)), set.WALL.getId());
                ((ForgeRegistry)ForgeRegistries.BLOCKS).addAlias(Luminax.prefix(String.format("%s_pressure_plate", set.name)), set.PRESSURE_PLATE.getId());
                ((ForgeRegistry)ForgeRegistries.BLOCKS).addAlias(Luminax.prefix(String.format("%s_button", set.name)), set.BUTTON.getId());
                ((ForgeRegistry)ForgeRegistries.BLOCKS).addAlias(Luminax.prefix(String.format("%s_dim_block", set.name)), set.DIM_BLOCK.getId());
                ((ForgeRegistry)ForgeRegistries.BLOCKS).addAlias(Luminax.prefix(String.format("%s_dim_slab", set.name)), set.DIM_SLAB.getId());
                ((ForgeRegistry)ForgeRegistries.BLOCKS).addAlias(Luminax.prefix(String.format("%s_dim_stairs", set.name)), set.DIM_STAIRS.getId());
                ((ForgeRegistry)ForgeRegistries.BLOCKS).addAlias(Luminax.prefix(String.format("%s_dim_wall", set.name)), set.DIM_WALL.getId());
                ((ForgeRegistry)ForgeRegistries.BLOCKS).addAlias(Luminax.prefix(String.format("%s_dim_pressure_plate", set.name)), set.DIM_PRESSURE_PLATE.getId());
                ((ForgeRegistry)ForgeRegistries.BLOCKS).addAlias(Luminax.prefix(String.format("%s_dim_button", set.name)), set.DIM_BUTTON.getId());
            });
        }
    }
}

