/*
 * Decompiled with CFR 0.152.
 */
package top.seraphjack.simplelogin.server;

import java.lang.reflect.Field;
import java.util.List;
import net.minecraft.commands.CommandSource;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.CommandEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import net.minecraftforge.network.PacketDistributor;
import top.seraphjack.simplelogin.SLConfig;
import top.seraphjack.simplelogin.SimpleLogin;
import top.seraphjack.simplelogin.network.MessageRequestLogin;
import top.seraphjack.simplelogin.network.NetworkLoader;
import top.seraphjack.simplelogin.server.handler.PlayerLoginHandler;

@OnlyIn(value=Dist.DEDICATED_SERVER)
@Mod.EventBusSubscriber(value={Dist.DEDICATED_SERVER}, modid="simplelogin")
public class ServerSideEventHandler {
    private static final Field COMMAND_SOURCE_FIELD;

    @SubscribeEvent
    public static void playerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        PlayerLoginHandler.instance().playerJoin((ServerPlayer)event.getEntity());
        NetworkLoader.INSTANCE.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new MessageRequestLogin());
    }

    @SubscribeEvent
    public static void playerLeave(PlayerEvent.PlayerLoggedOutEvent event) {
        PlayerLoginHandler.instance().playerLeave((ServerPlayer)event.getEntity());
    }

    @SubscribeEvent
    public static void onCommand(CommandEvent event) {
        String command = event.getParseResults().getReader().getString();
        if (command.startsWith("/")) {
            command = command.substring(1);
        }
        SimpleLogin.logger.debug("Checking command '{}'", (Object)command);
        CommandSource realSource = ServerSideEventHandler.getRealSource((CommandSourceStack)event.getParseResults().getContext().getSource());
        if (realSource == null) {
            return;
        }
        if (!(realSource instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer cast = (ServerPlayer)realSource;
        if (PlayerLoginHandler.instance().hasPlayerLoggedIn(cast.m_6302_())) {
            return;
        }
        if (((List)SLConfig.SERVER.whitelistCommands.get()).contains(command)) {
            return;
        }
        SimpleLogin.logger.warn("Denied {} to execute command '{}' before login", (Object)((CommandSourceStack)event.getParseResults().getContext().getSource()).m_81368_(), (Object)command);
        event.setCanceled(true);
    }

    private static CommandSource getRealSource(CommandSourceStack sourceStack) {
        if (COMMAND_SOURCE_FIELD == null) {
            return null;
        }
        try {
            return (CommandSource)COMMAND_SOURCE_FIELD.get(sourceStack);
        }
        catch (IllegalAccessException e) {
            SimpleLogin.logger.error("Failed to get real command source", (Throwable)e);
            return null;
        }
    }

    static {
        Field f;
        try {
            f = ObfuscationReflectionHelper.findField(CommandSourceStack.class, (String)"f_81288_");
            f.setAccessible(true);
        }
        catch (Exception ex) {
            SimpleLogin.logger.error("Failed to get command source field", (Throwable)ex);
            f = null;
        }
        COMMAND_SOURCE_FIELD = f;
    }
}

