/*
 * Decompiled with CFR 0.152.
 */
package top.seraphjack.simplelogin.client;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import top.seraphjack.simplelogin.SimpleLogin;

@OnlyIn(value=Dist.CLIENT)
public final class PasswordHolder {
    private static PasswordHolder INSTANCE;
    public static final Path PASSWORD_FILE_PATH;
    private String password = null;
    private String pendingPassword = null;
    private boolean initialized = false;

    public static PasswordHolder instance() {
        if (INSTANCE == null) {
            INSTANCE = new PasswordHolder();
        }
        return INSTANCE;
    }

    private PasswordHolder() {
        if (Files.exists(PASSWORD_FILE_PATH, new LinkOption[0])) {
            this.initialized = true;
            this.read();
        }
    }

    private void read() {
        try {
            this.password = Files.readString(PASSWORD_FILE_PATH);
        }
        catch (IOException e) {
            SimpleLogin.logger.error("Failed to load password", (Throwable)e);
        }
    }

    private void save() {
        try {
            Files.writeString(PASSWORD_FILE_PATH, (CharSequence)this.password, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
        }
        catch (IOException e) {
            SimpleLogin.logger.error("Failed to save password", (Throwable)e);
        }
    }

    public boolean initialized() {
        return this.initialized;
    }

    public void initialize(String password) {
        if (this.initialized) {
            throw new IllegalStateException();
        }
        this.initialized = true;
        this.password = password;
        this.save();
    }

    public void setPendingPassword(String o) {
        if (!this.initialized) {
            throw new IllegalStateException();
        }
        this.pendingPassword = o;
        this.save();
    }

    public void applyPending() {
        if (!this.initialized) {
            throw new IllegalStateException();
        }
        if (this.pendingPassword == null) {
            return;
        }
        this.password = this.pendingPassword;
        this.save();
        this.pendingPassword = null;
    }

    public void dropPending() {
        if (!this.initialized) {
            throw new IllegalStateException();
        }
        this.pendingPassword = null;
    }

    public String password() {
        if (!this.initialized) {
            throw new IllegalStateException();
        }
        return this.password;
    }

    static {
        PASSWORD_FILE_PATH = Paths.get(".", ".sl_password");
    }
}

