/*
 * Decompiled with CFR 0.152.
 */
package com.codinglitch.simpleradio.radio;

import com.codinglitch.simpleradio.CommonSimpleRadio;
import com.codinglitch.simpleradio.SimpleRadioLibrary;
import com.codinglitch.simpleradio.api.FrequencingRegistry;
import com.codinglitch.simpleradio.api.central.FrequencingType;
import com.codinglitch.simpleradio.api.central.Frequency;
import com.codinglitch.simpleradio.api.central.Medium;
import com.codinglitch.simpleradio.api.central.WorldlyPosition;
import com.codinglitch.simpleradio.core.registry.SimpleRadioFrequencing;
import com.codinglitch.simpleradio.core.registry.entities.Wire;
import com.codinglitch.simpleradio.radio.RadioReceiver;
import com.codinglitch.simpleradio.radio.RadioRouter;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.sounds.SoundEvent;
import org.joml.Math;

public class RadioSource {
    public UUID owner;
    public UUID originalOwner;
    public WorldlyPosition origin;
    public short frequencingType = (short)-1;
    public byte[] data;
    public SoundEvent soundEvent;
    public float pitch = 1.0f;
    public float volume;
    public float offset;
    public long seed;
    public float activity;
    public List<Short> record = new ArrayList<Short>();
    public Frequency frequencyMedium;
    public Wire wireMedium;
    public float transmissionCap = 50.0f;
    public float transmissionPower = 50.0f;

    protected RadioSource() {
    }

    public RadioSource(UUID owner, WorldlyPosition location, byte[] data, float volume) {
        this.owner = owner;
        this.origin = location;
        this.volume = volume;
        this.data = data;
    }

    public RadioSource(UUID owner, WorldlyPosition location, SoundEvent soundEvent, float volume) {
        this.owner = owner;
        this.origin = location;
        this.volume = volume;
        this.soundEvent = soundEvent;
    }

    public UUID getRealOwner() {
        return this.originalOwner == null ? this.owner : this.originalOwner;
    }

    public void delegate(UUID owner) {
        this.originalOwner = this.owner;
        this.owner = owner;
    }

    public void addPower(float power) {
        this.transmissionPower = Math.min((float)(this.transmissionPower + power), (float)this.transmissionCap);
    }

    public FrequencingType getFrequencingType() {
        FrequencingType type = FrequencingRegistry.getById(this.frequencingType);
        if (type == null) {
            CommonSimpleRadio.error("Missing frequencing type for id {}!", this.frequencingType);
        }
        return type;
    }

    public RadioSource copy() {
        RadioSource copy = new RadioSource();
        copy.owner = this.owner;
        copy.originalOwner = this.originalOwner;
        copy.origin = this.origin;
        copy.frequencingType = this.frequencingType;
        copy.data = this.data;
        copy.soundEvent = this.soundEvent;
        copy.volume = this.volume;
        copy.pitch = this.pitch;
        copy.offset = this.offset;
        copy.seed = this.seed;
        copy.record = new ArrayList<Short>(this.record);
        copy.frequencyMedium = this.frequencyMedium;
        copy.wireMedium = this.wireMedium;
        copy.transmissionPower = this.transmissionPower;
        copy.transmissionCap = this.transmissionCap;
        return copy;
    }

    public boolean willShort(RadioRouter router) {
        short identifier = router.getIdentifier();
        for (short recordIdentifier : this.record) {
            if (identifier != recordIdentifier) continue;
            return true;
        }
        return false;
    }

    public void visit(RadioRouter router) {
        this.record.add(router.getIdentifier());
    }

    public void travel(RadioRouter from, RadioRouter to, Medium medium) {
        WorldlyPosition fromPos = from.getLocation();
        WorldlyPosition toPos = to.getLocation();
        double distance = fromPos.distance(toPos);
        double transmissionDiminishment = 0.0;
        FrequencingType.DiminishmentMethod diminishmentMethod = FrequencingType.DiminishmentMethod.ADDITIVE;
        if (medium instanceof Wire) {
            Wire wire = (Wire)medium;
            transmissionDiminishment = SimpleRadioFrequencing.WIRE.transmissionDiminishment;
            diminishmentMethod = SimpleRadioFrequencing.WIRE.diminishmentMethod;
            this.wireMedium = wire;
        } else if (medium instanceof Frequency) {
            Frequency frequency = (Frequency)medium;
            FrequencingType type = this.getFrequencingType();
            transmissionDiminishment = type.transmissionDiminishment;
            diminishmentMethod = type.diminishmentMethod;
            if (to instanceof RadioReceiver) {
                RadioReceiver receiver = (RadioReceiver)to;
                if (distance > (double)receiver.frequencingType.receptionFloor) {
                    distance = Math.max((double)receiver.frequencingType.receptionFloor, (double)(distance - receiver.getPower()));
                }
            }
            if (fromPos.level.m_6042_() != toPos.level.m_6042_()) {
                if (SimpleRadioLibrary.SERVER_CONFIG.frequency.crossDimensional.booleanValue()) {
                    double interference = SimpleRadioLibrary.SERVER_CONFIG.frequency.dimensionalInterference;
                    transmissionDiminishment += frequency.modulation == Frequency.Modulation.FREQUENCY ? interference : interference / 2.0;
                } else {
                    this.transmissionPower = 0.0f;
                    transmissionDiminishment = 0.0;
                }
            }
            this.frequencyMedium = frequency;
        }
        switch (diminishmentMethod) {
            case ADDITIVE: {
                this.transmissionPower = (float)Math.max((double)0.0, (double)((double)this.transmissionPower - distance * transmissionDiminishment));
                break;
            }
            case MULTIPLICATIVE: {
                this.transmissionPower = (float)Math.max((double)0.0, (double)((double)this.transmissionPower - (double)this.transmissionCap * transmissionDiminishment));
            }
        }
        this.visit(to);
    }

    public double computeSeverity() {
        double base = 0.0;
        double severity = 0.0;
        if (this.frequencyMedium != null) {
            double diminishThreshold = this.getFrequencingType().getDiminishThreshold(this.frequencyMedium.modulation);
            base = this.frequencyMedium.modulation == Frequency.Modulation.FREQUENCY ? SimpleRadioLibrary.SERVER_CONFIG.frequency.baseFMInterference : SimpleRadioLibrary.SERVER_CONFIG.frequency.baseAMInterference;
            severity = 1.0 - Math.clamp((double)0.0, (double)1.0, (double)((double)this.transmissionPower / diminishThreshold));
        }
        return Math.clamp((double)0.0, (double)100.0, (double)(base + severity * (100.0 - base)));
    }

    public boolean isValid() {
        return this.origin != null;
    }
}

