/*
 * Decompiled with CFR 0.152.
 */
package com.codinglitch.simpleradio.core.registry.blocks;

import com.codinglitch.simpleradio.SimpleRadioLibrary;
import com.codinglitch.simpleradio.api.central.Speaking;
import com.codinglitch.simpleradio.api.central.WorldlyPosition;
import com.codinglitch.simpleradio.client.ClientRadioManager;
import com.codinglitch.simpleradio.core.registry.SimpleRadioBlockEntities;
import com.codinglitch.simpleradio.core.registry.SimpleRadioBlocks;
import com.codinglitch.simpleradio.core.registry.SimpleRadioSounds;
import com.codinglitch.simpleradio.core.registry.blocks.AuditoryBlockEntity;
import com.codinglitch.simpleradio.platform.Services;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class SpeakerBlockEntity
extends AuditoryBlockEntity
implements Speaking {
    public boolean isActive = false;

    public SpeakerBlockEntity(BlockPos pos, BlockState state) {
        super(SimpleRadioBlockEntities.SPEAKER, pos, state);
    }

    public void m_7651_() {
        if (this.f_58857_ != null && !this.f_58857_.f_46443_ && this.speaker != null) {
            this.f_58857_.m_6263_(null, (double)this.speaker.location.x, (double)this.speaker.location.y, (double)this.speaker.location.z, SimpleRadioSounds.RADIO_CLOSE, SoundSource.PLAYERS, 1.0f, 1.0f);
        }
        this.inactivate();
        super.m_7651_();
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.loadTag(tag);
    }

    @Override
    public void m_183515_(CompoundTag tag) {
        this.saveTag(tag);
        super.m_183515_(tag);
    }

    public void m_187476_(ItemStack stack) {
        this.saveTag(stack.m_41784_());
        super.m_187476_(stack);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, SpeakerBlockEntity blockEntity) {
        if (!blockEntity.isActive && blockEntity.id != null) {
            blockEntity.activate();
        }
        if (blockEntity.f_58857_ == null) {
            return;
        }
        if (blockEntity.speaker != null && blockEntity.speaker.activityTime >= 0) {
            if (blockEntity.speaker.activityTime % SimpleRadioLibrary.SERVER_CONFIG.speaker.redstonePolling == 0) {
                level.m_46672_(pos, (Block)SimpleRadioBlocks.SPEAKER);
            }
            if (SimpleRadioLibrary.CLIENT_CONFIG.speaker.particleInterval != 0 && blockEntity.f_58857_.f_46443_ && blockEntity.speaker.activityTime % SimpleRadioLibrary.CLIENT_CONFIG.speaker.particleInterval == 0) {
                ClientRadioManager.handleSpeakParticle(state, blockEntity);
            }
        }
    }

    public void inactivate() {
        if (this.isActive) {
            this.stopSpeaking();
        }
        this.isActive = false;
    }

    public void activate() {
        WorldlyPosition location = Services.COMPAT.modifyPosition(WorldlyPosition.of(this.f_58858_, this.f_58857_, this.f_58858_));
        this.speaker = SimpleRadioBlocks.SPEAKER.getOrCreateSpeaker(location, this.id, this.m_58900_());
        if (!this.f_58857_.f_46443_) {
            this.f_58857_.m_6263_(null, (double)location.x, (double)location.y, (double)location.z, SimpleRadioSounds.RADIO_OPEN, SoundSource.PLAYERS, 1.0f, 1.0f);
        }
        this.isActive = true;
    }

    @Override
    public void loadTag(CompoundTag tag) {
        this.inactivate();
        super.loadTag(tag);
    }
}

