/*
 * Decompiled with CFR 0.152.
 */
package com.codinglitch.simpleradio.core.registry.blocks;

import com.codinglitch.simpleradio.api.CatalystRegistry;
import com.codinglitch.simpleradio.api.central.Catalyst;
import com.codinglitch.simpleradio.core.registry.blocks.AuditoryBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;

public abstract class CatalyzingBlockEntity
extends AuditoryBlockEntity {
    public Catalyst catalyst;
    public boolean catalyzed;

    public CatalyzingBlockEntity(BlockEntityType<?> blockEntityType, BlockPos pos, BlockState state) {
        super(blockEntityType, pos, state);
    }

    public InteractionResult trySwapCatalyst(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        ItemStack stack = player.m_21120_(hand);
        if (this.catalyst == null) {
            Catalyst catalyst;
            if (!stack.m_41619_() && (catalyst = CatalystRegistry.get(stack.m_41720_())) != null) {
                stack.m_41774_(1);
                this.catalyst = catalyst;
                level.m_7260_(pos, state, state, 2);
                this.m_6596_();
                if (!level.f_46443_) {
                    level.m_5594_(null, pos, SoundEvents.f_12013_, SoundSource.BLOCKS, 1.0f, 1.0f);
                }
                return InteractionResult.SUCCESS;
            }
        } else if (stack.m_41619_()) {
            player.m_21008_(hand, new ItemStack((ItemLike)this.catalyst.associate));
            this.catalyst = null;
            level.m_7260_(pos, state, state, 2);
            this.m_6596_();
            if (!level.f_46443_) {
                level.m_5594_(null, pos, SoundEvents.f_12016_, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            return InteractionResult.SUCCESS;
        }
        return null;
    }

    public static void tick(Level level, BlockPos pos, BlockState blockState, CatalyzingBlockEntity blockEntity) {
        BlockPos adaptorLocation = blockEntity.getAdaptorLocation();
        BlockState state = level.m_8055_(adaptorLocation);
        blockEntity.catalyzed = !state.m_60795_();
    }

    public abstract BlockPos getAdaptorLocation();

    @Override
    public void loadTag(CompoundTag tag) {
        super.loadTag(tag);
        if (tag.m_128441_("catalyst")) {
            this.catalyst = CatalystRegistry.get(ResourceLocation.m_135820_((String)tag.m_128461_("catalyst")));
        }
    }

    @Override
    public void saveTag(CompoundTag tag) {
        super.saveTag(tag);
        if (this.catalyst != null) {
            tag.m_128359_("catalyst", this.catalyst.location.toString());
        }
    }
}

