/*
 * Decompiled with CFR 0.152.
 */
package com.codinglitch.simpleradio.core.registry.blocks;

import com.codinglitch.simpleradio.SimpleRadioLibrary;
import com.codinglitch.simpleradio.api.central.Frequencing;
import com.codinglitch.simpleradio.core.registry.blocks.InsulatorBlock;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import oshi.util.tuples.Pair;

public class AntennaBlock
extends Block {
    public static final BooleanProperty UP = BlockStateProperties.f_61366_;
    public static final BooleanProperty DOWN = BlockStateProperties.f_61367_;
    public static final BooleanProperty UNSTABLE = BlockStateProperties.f_61361_;
    public static final BooleanProperty ATTACHED = BlockStateProperties.f_61386_;
    public static final BooleanProperty COLUMN = BooleanProperty.m_61465_((String)"column");
    public static final EnumProperty<Direction.Axis> AXIS = BlockStateProperties.f_61365_;
    private static final VoxelShape SHAPE = Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)10.0, (double)12.0);
    private static final VoxelShape COLUMN_SHAPE = Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);
    private static final VoxelShape HORIZONTAL_X_SHAPE = Block.m_49796_((double)0.0, (double)4.0, (double)4.0, (double)16.0, (double)12.0, (double)12.0);
    private static final VoxelShape HORIZONTAL_Z_SHAPE = Block.m_49796_((double)4.0, (double)4.0, (double)0.0, (double)12.0, (double)12.0, (double)16.0);
    private static final Direction[] Z_PRIORITY = new Direction[]{Direction.NORTH, Direction.SOUTH, Direction.EAST, Direction.WEST};
    private static final Direction[] X_PRIORITY = new Direction[]{Direction.EAST, Direction.WEST, Direction.NORTH, Direction.SOUTH};
    private static int MAX_DISTANCE = 8;

    public static void onLexiconRevision() {
        MAX_DISTANCE = SimpleRadioLibrary.SERVER_CONFIG.antenna.maxDistance;
    }

    public AntennaBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)UP, (Comparable)Boolean.valueOf(false))).m_61124_((Property)DOWN, (Comparable)Boolean.valueOf(true))).m_61124_((Property)UNSTABLE, (Comparable)Boolean.valueOf(false))).m_61124_((Property)ATTACHED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)COLUMN, (Comparable)Boolean.valueOf(false))).m_61124_(AXIS, (Comparable)Direction.Axis.Y));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> stateBuilder) {
        super.m_7926_(stateBuilder.m_61104_(new Property[]{UP}).m_61104_(new Property[]{DOWN}).m_61104_(new Property[]{UNSTABLE}).m_61104_(new Property[]{ATTACHED}).m_61104_(new Property[]{COLUMN}).m_61104_(new Property[]{AXIS}));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        if (((Boolean)state.m_61143_((Property)UP)).booleanValue()) {
            if (state.m_61143_(AXIS) == Direction.Axis.X) {
                return Shapes.m_83110_((VoxelShape)COLUMN_SHAPE, (VoxelShape)HORIZONTAL_X_SHAPE);
            }
            if (state.m_61143_(AXIS) == Direction.Axis.Z) {
                return Shapes.m_83110_((VoxelShape)COLUMN_SHAPE, (VoxelShape)HORIZONTAL_Z_SHAPE);
            }
            return COLUMN_SHAPE;
        }
        if (((Boolean)state.m_61143_((Property)DOWN)).booleanValue()) {
            if (state.m_61143_(AXIS) == Direction.Axis.X) {
                return Shapes.m_83110_((VoxelShape)SHAPE, (VoxelShape)HORIZONTAL_X_SHAPE);
            }
            if (state.m_61143_(AXIS) == Direction.Axis.Z) {
                return Shapes.m_83110_((VoxelShape)SHAPE, (VoxelShape)HORIZONTAL_Z_SHAPE);
            }
        } else {
            if (state.m_61143_(AXIS) == Direction.Axis.X) {
                return HORIZONTAL_X_SHAPE;
            }
            if (state.m_61143_(AXIS) == Direction.Axis.Z) {
                return HORIZONTAL_Z_SHAPE;
            }
        }
        return COLUMN_SHAPE;
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState otherState, LevelAccessor accessor, BlockPos pos, BlockPos otherPos) {
        BlockState newState;
        Pair<Integer, Boolean> result;
        if (!accessor.m_5776_()) {
            accessor.m_186460_(pos, (Block)this, 0);
        }
        if ((Integer)(result = this.crawlAntenna(pos, newState = this.update(pos, state, accessor, null), accessor)).getA() == -1) {
            return (BlockState)((BlockState)state.m_61124_((Property)ATTACHED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)UNSTABLE, (Comparable)Boolean.valueOf(true));
        }
        return (BlockState)newState.m_61124_((Property)COLUMN, (Comparable)((Boolean)result.getB()));
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState state = super.m_5573_(context);
        state = this.update(context.m_8083_(), state, (LevelAccessor)context.m_43725_(), context.m_43719_().m_122434_());
        return state;
    }

    public void m_6807_(BlockState state, Level level, BlockPos pos, BlockState otherState, boolean b) {
    }

    public void m_6786_(LevelAccessor accessor, BlockPos pos, BlockState state) {
        super.m_6786_(accessor, pos, state);
    }

    public boolean m_7898_(BlockState state, LevelReader reader, BlockPos pos) {
        Direction.Axis axis;
        BlockState adjacentState;
        boolean flag = false;
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            adjacentState = reader.m_8055_(pos.m_121945_(direction));
            if (!(adjacentState.m_60734_() instanceof AntennaBlock)) continue;
            axis = (Direction.Axis)adjacentState.m_61143_(AXIS);
            if (!axis.m_122478_() && direction.m_122434_() != axis) {
                return false;
            }
            flag = true;
        }
        if (flag) {
            for (Direction direction : Direction.Plane.VERTICAL) {
                adjacentState = reader.m_8055_(pos.m_121945_(direction));
                if (!(adjacentState.m_60734_() instanceof AntennaBlock) || (axis = (Direction.Axis)adjacentState.m_61143_(AXIS)) != state.m_61143_(AXIS)) continue;
                return false;
            }
            return true;
        }
        BlockPos bottomPos = pos.m_7495_();
        BlockState bottomState = reader.m_8055_(bottomPos);
        return bottomState.m_60734_() instanceof AntennaBlock || bottomState.m_60783_((BlockGetter)reader, bottomPos, Direction.UP);
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource randomSource) {
        if (((Boolean)state.m_61143_((Property)UNSTABLE)).booleanValue()) {
            BlockState belowState = level.m_8055_(pos.m_7495_());
            if (!belowState.m_60795_()) {
                Block block = state.m_60734_();
                ItemEntity itemEntity = new ItemEntity((Level)level, (double)pos.m_123341_(), (double)(pos.m_123342_() + 1), (double)pos.m_123343_(), new ItemStack((ItemLike)block));
                itemEntity.m_32060_();
                level.m_7967_((Entity)itemEntity);
                level.m_7731_(pos, state.m_60819_().m_76188_(), 3);
            } else {
                FallingBlockEntity fallingBlockEntity = FallingBlockEntity.m_201971_((Level)level, (BlockPos)pos, (BlockState)((BlockState)state.m_61124_((Property)UNSTABLE, (Comparable)Boolean.valueOf(false))));
            }
        }
    }

    public BlockState update(BlockPos pos, BlockState state, LevelAccessor accessor, @Nullable Direction.Axis priority) {
        for (Direction direction : priority == Direction.Axis.X ? X_PRIORITY : Z_PRIORITY) {
            Direction.Axis otherAxis;
            Direction.Axis axis = (Direction.Axis)state.m_61143_(AXIS);
            if (!axis.m_122478_() && !axis.test(direction)) continue;
            BlockPos otherPos = pos.m_121945_(direction);
            BlockState otherState = accessor.m_8055_(otherPos);
            BlockState otherSideState = accessor.m_8055_(pos.m_121945_(direction.m_122424_()));
            boolean supporting = false;
            if (otherState.m_60734_() instanceof AntennaBlock) {
                otherAxis = (Direction.Axis)otherState.m_61143_(AXIS);
                boolean bl = supporting = otherAxis == Direction.Axis.Y || otherAxis == direction.m_122434_();
            }
            if (otherSideState.m_60734_() instanceof AntennaBlock) {
                otherAxis = (Direction.Axis)otherSideState.m_61143_(AXIS);
                supporting = supporting || otherAxis == Direction.Axis.Y || otherAxis == direction.m_122434_();
            }
            state = supporting ? (BlockState)state.m_61124_(AXIS, (Comparable)direction.m_122434_()) : (BlockState)state.m_61124_(AXIS, (Comparable)Direction.Axis.Y);
        }
        BlockPos bottomPos = pos.m_7495_();
        BlockState bottomState = accessor.m_8055_(bottomPos);
        state = (BlockState)((BlockState)((BlockState)state.m_61124_((Property)UP, (Comparable)Boolean.valueOf(accessor.m_8055_(pos.m_7494_()).m_60734_() instanceof AntennaBlock))).m_61124_((Property)DOWN, (Comparable)Boolean.valueOf(!bottomState.m_60795_()))).m_61124_((Property)ATTACHED, (Comparable)Boolean.valueOf(bottomState.m_60783_((BlockGetter)accessor, bottomPos, Direction.UP)));
        return state;
    }

    public Pair<Integer, Boolean> crawlAntenna(BlockPos pos, BlockState state, LevelAccessor accessor) {
        if (((Boolean)state.m_61143_((Property)ATTACHED)).booleanValue()) {
            return new Pair((Object)0, (Object)true);
        }
        int columnDistance = -1;
        boolean wasDirect = false;
        if (((Boolean)state.m_61143_((Property)DOWN)).booleanValue()) {
            Pair<Integer, Boolean> result = this.crawlColumn(pos.m_122032_().m_122173_(Direction.DOWN), accessor, 1);
            columnDistance = (Integer)result.getA();
            wasDirect = (Boolean)result.getB();
        }
        int axisDistance = -1;
        Direction.Axis axis = (Direction.Axis)state.m_61143_(AXIS);
        if (!axis.m_122478_()) {
            axisDistance = this.crawlAxis(pos.m_122032_(), axis, accessor, 0);
        }
        if (columnDistance == -1) {
            return new Pair((Object)axisDistance, (Object)wasDirect);
        }
        if (axisDistance == -1) {
            return new Pair((Object)columnDistance, (Object)wasDirect);
        }
        if (columnDistance <= axisDistance) {
            return new Pair((Object)columnDistance, (Object)wasDirect);
        }
        return new Pair((Object)axisDistance, (Object)wasDirect);
    }

    public int climbAntenna(BlockPos pos, LevelAccessor accessor) {
        AtomicInteger score = new AtomicInteger();
        ArrayList<BlockPos> navigated = new ArrayList<BlockPos>();
        this.climbColumn(pos.m_122032_(), accessor, score, 0, navigated);
        return score.get();
    }

    public void notifyExtension(BlockPos pos, LevelAccessor accessor) {
        BlockPos travelledPos = InsulatorBlock.travelExtension(pos, accessor);
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            BlockPos relativePosition = travelledPos.m_121945_(direction);
            BlockEntity blockEntity = accessor.m_7702_(relativePosition);
            if (!(blockEntity instanceof Frequencing)) continue;
            Frequencing frequencing = (Frequencing)blockEntity;
            frequencing.markDirty();
        }
    }

    public void climbAxis(BlockPos.MutableBlockPos currentPos, Direction.Axis axis, LevelAccessor accessor, AtomicInteger score, int distance, List<BlockPos> navigated) {
        Direction positiveDirection = Direction.m_122390_((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)axis);
        Direction negativeDirection = Direction.m_122390_((Direction.AxisDirection)Direction.AxisDirection.NEGATIVE, (Direction.Axis)axis);
        this.climbRow(currentPos.m_122032_().m_122173_(positiveDirection), positiveDirection, accessor, score, distance + 1, navigated);
        this.climbRow(currentPos.m_122032_().m_122173_(negativeDirection), negativeDirection, accessor, score, distance + 1, navigated);
    }

    public int crawlAxis(BlockPos.MutableBlockPos currentPos, Direction.Axis axis, LevelAccessor accessor, int distance) {
        Direction positiveDirection = Direction.m_122390_((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)axis);
        Direction negativeDirection = Direction.m_122390_((Direction.AxisDirection)Direction.AxisDirection.NEGATIVE, (Direction.Axis)axis);
        int positiveDistance = this.crawlRow(currentPos.m_122032_().m_122173_(positiveDirection), positiveDirection, accessor, distance + 1);
        int negativeDistance = this.crawlRow(currentPos.m_122032_().m_122173_(negativeDirection), negativeDirection, accessor, distance + 1);
        if (positiveDistance == -1) {
            return negativeDistance;
        }
        if (negativeDistance == -1) {
            return positiveDistance;
        }
        return Math.min(positiveDistance, negativeDistance);
    }

    public void climbRow(BlockPos.MutableBlockPos currentPos, Direction direction, LevelAccessor accessor, AtomicInteger score, int distance, List<BlockPos> navigated) {
        AtomicInteger dist = new AtomicInteger(distance);
        this.iterateDirection(currentPos, accessor, direction, state -> {
            if (navigated.stream().anyMatch(nav -> nav.equals((Object)currentPos))) {
                return false;
            }
            if (dist.get() > MAX_DISTANCE) {
                return false;
            }
            navigated.add(currentPos.m_7949_());
            if (((Boolean)state.m_61143_((Property)UP)).booleanValue()) {
                this.climbColumn(currentPos.m_122032_().m_122173_(Direction.UP), accessor, score, distance + 1, navigated);
            }
            score.getAndIncrement();
            dist.getAndIncrement();
            return true;
        });
    }

    public int crawlRow(BlockPos.MutableBlockPos currentPos, Direction direction, LevelAccessor accessor, int distance) {
        ArrayList distances = new ArrayList();
        AtomicInteger dist = new AtomicInteger(distance);
        this.iterateDirection(currentPos, accessor, direction, state -> {
            int otherDistance;
            if (dist.get() > MAX_DISTANCE) {
                return false;
            }
            if (((Boolean)state.m_61143_((Property)ATTACHED)).booleanValue()) {
                distances.add(dist.get());
                return false;
            }
            if (((Boolean)state.m_61143_((Property)DOWN)).booleanValue() && (otherDistance = ((Integer)this.crawlColumn(currentPos.m_122032_().m_122173_(Direction.DOWN), accessor, dist.get() + 1).getA()).intValue()) != -1) {
                distances.add(otherDistance);
            }
            dist.getAndIncrement();
            return true;
        });
        if (distances.isEmpty()) {
            return -1;
        }
        return (Integer)Collections.min(distances);
    }

    public void climbColumn(BlockPos.MutableBlockPos currentPos, LevelAccessor accessor, AtomicInteger score, int distance, List<BlockPos> navigated) {
        AtomicInteger dist = new AtomicInteger(distance);
        this.iterateDirection(currentPos, accessor, Direction.UP, state -> {
            if (navigated.stream().anyMatch(nav -> nav.equals((Object)currentPos))) {
                return false;
            }
            if (dist.get() > MAX_DISTANCE) {
                return false;
            }
            navigated.add(currentPos.m_7949_());
            Direction.Axis axis = (Direction.Axis)state.m_61143_(AXIS);
            if (!axis.m_122478_()) {
                score.addAndGet(2);
                this.climbAxis(currentPos, axis, accessor, score, distance, navigated);
            }
            if (!((Boolean)state.m_61143_((Property)UP)).booleanValue()) {
                score.addAndGet(2);
                return false;
            }
            score.getAndIncrement();
            dist.getAndIncrement();
            return true;
        });
    }

    public Pair<Integer, Boolean> crawlColumn(BlockPos.MutableBlockPos currentPos, LevelAccessor accessor, int distance) {
        ArrayList distances = new ArrayList();
        AtomicBoolean isColumn = new AtomicBoolean(false);
        AtomicInteger dist = new AtomicInteger(distance);
        this.iterateDirection(currentPos, accessor, Direction.DOWN, state -> {
            int otherDistance;
            if (dist.get() > MAX_DISTANCE) {
                return false;
            }
            if (((Boolean)state.m_61143_((Property)ATTACHED)).booleanValue()) {
                this.notifyExtension(currentPos.m_7495_(), accessor);
                isColumn.set(true);
                distances.add(dist.get());
                return false;
            }
            Direction.Axis axis = (Direction.Axis)state.m_61143_(AXIS);
            if (!axis.m_122478_() && (otherDistance = this.crawlAxis(currentPos, axis, accessor, dist.get())) != -1) {
                distances.add(otherDistance);
            }
            if (!((Boolean)state.m_61143_((Property)DOWN)).booleanValue()) {
                return false;
            }
            dist.getAndIncrement();
            return true;
        });
        if (distances.isEmpty()) {
            return new Pair((Object)-1, (Object)isColumn.get());
        }
        return new Pair((Object)((Integer)Collections.min(distances)), (Object)isColumn.get());
    }

    public void iterateDirection(BlockPos.MutableBlockPos currentPos, LevelAccessor accessor, Direction direction, Function<BlockState, Boolean> iterator) {
        BlockState currentState = accessor.m_8055_((BlockPos)currentPos);
        while (currentState.m_60734_() instanceof AntennaBlock && iterator.apply(currentState).booleanValue()) {
            currentPos.m_122173_(direction);
            currentState = accessor.m_8055_((BlockPos)currentPos);
        }
    }
}

