/*
 * Decompiled with CFR 0.152.
 */
package com.codinglitch.simpleradio.core;

import com.codinglitch.simpleradio.CommonSimpleRadio;
import com.codinglitch.simpleradio.core.registry.SimpleRadioItems;
import com.google.gson.JsonObject;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;

public class ItemsEnabledCondition
implements ICondition {
    private static final ResourceLocation NAME = CommonSimpleRadio.id("items_enabled");
    private final String item;

    public ItemsEnabledCondition(String item) {
        this.item = item;
    }

    public ResourceLocation getID() {
        return NAME;
    }

    public boolean test(ICondition.IContext context) {
        return SimpleRadioItems.getByName((String)this.item).enabled;
    }

    public String toString() {
        return "item_enabled(\"" + this.item + "\")";
    }

    public static class Serializer
    implements IConditionSerializer<ItemsEnabledCondition> {
        public static final Serializer INSTANCE = new Serializer();

        public void write(JsonObject json, ItemsEnabledCondition value) {
            json.addProperty("item", value.item);
        }

        public ItemsEnabledCondition read(JsonObject json) {
            return new ItemsEnabledCondition(GsonHelper.m_13906_((JsonObject)json, (String)"item"));
        }

        public ResourceLocation getID() {
            return NAME;
        }
    }
}

