/*
 * Decompiled with CFR 0.152.
 */
package com.codinglitch.simpleradio.core;

import com.codinglitch.simpleradio.CommonSimpleRadio;
import com.codinglitch.simpleradio.core.ItemsEnabledCondition;
import com.codinglitch.simpleradio.core.networking.CustomPacket;
import com.codinglitch.simpleradio.core.networking.SimpleRadioNetworking;
import com.codinglitch.simpleradio.core.registry.SimpleRadioBlockEntities;
import com.codinglitch.simpleradio.core.registry.SimpleRadioBlocks;
import com.codinglitch.simpleradio.core.registry.SimpleRadioEntities;
import com.codinglitch.simpleradio.core.registry.SimpleRadioItems;
import com.codinglitch.simpleradio.core.registry.SimpleRadioMenus;
import com.codinglitch.simpleradio.core.registry.SimpleRadioParticles;
import com.codinglitch.simpleradio.datagen.SimpleRadioBlockLootTableProvider;
import com.codinglitch.simpleradio.datagen.SimpleRadioRecipeProvider;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegisterEvent;
import org.apache.logging.log4j.util.TriConsumer;

@Mod.EventBusSubscriber(modid="simpleradio", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ForgeLoader {
    private static final String PROTOCOL_VERSION = "0";
    public static final SimpleChannel CHANNEL = NetworkRegistry.newSimpleChannel((ResourceLocation)CommonSimpleRadio.id("channel"), () -> "0", "0"::equals, "0"::equals);

    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        generator.addProvider(event.includeServer(), (DataProvider)new SimpleRadioRecipeProvider(generator.getPackOutput()));
        generator.addProvider(event.includeServer(), (DataProvider)new LootTableProvider(generator.getPackOutput(), Set.of(), List.of(new LootTableProvider.SubProviderEntry(SimpleRadioBlockLootTableProvider::new, LootContextParamSets.f_81421_))));
    }

    @SubscribeEvent
    public static void register(RegisterEvent event) {
        event.register(ForgeRegistries.Keys.ITEMS, helper -> SimpleRadioItems.ITEMS.forEach((location, itemHolder) -> helper.register(location, (Object)itemHolder.get())));
        event.register(ForgeRegistries.Keys.BLOCKS, helper -> SimpleRadioBlocks.BLOCKS.forEach((arg_0, arg_1) -> ((RegisterEvent.RegisterHelper)helper).register(arg_0, arg_1)));
        event.register(ForgeRegistries.Keys.ENTITY_TYPES, helper -> SimpleRadioEntities.ENTITIES.forEach((arg_0, arg_1) -> ((RegisterEvent.RegisterHelper)helper).register(arg_0, arg_1)));
        event.register(ForgeRegistries.Keys.BLOCK_ENTITY_TYPES, helper -> SimpleRadioBlockEntities.BLOCK_ENTITIES.forEach((arg_0, arg_1) -> ((RegisterEvent.RegisterHelper)helper).register(arg_0, arg_1)));
        event.register(ForgeRegistries.Keys.MENU_TYPES, helper -> SimpleRadioMenus.MENUS.forEach((arg_0, arg_1) -> ((RegisterEvent.RegisterHelper)helper).register(arg_0, arg_1)));
        event.register(Registries.f_279569_, helper -> SimpleRadioMenus.CREATIVE_TABS.forEach((arg_0, arg_1) -> ((RegisterEvent.RegisterHelper)helper).register(arg_0, arg_1)));
        event.register(ForgeRegistries.Keys.PARTICLE_TYPES, helper -> SimpleRadioParticles.PARTICLES.forEach((arg_0, arg_1) -> ((RegisterEvent.RegisterHelper)helper).register(arg_0, arg_1)));
        event.register(ForgeRegistries.Keys.RECIPE_SERIALIZERS, helper -> CraftingHelper.register((IConditionSerializer)ItemsEnabledCondition.Serializer.INSTANCE));
        CommonSimpleRadio.load();
    }

    public static void loadPackets() {
        final AtomicInteger index = new AtomicInteger();
        SimpleRadioNetworking.loadServerbound(new SimpleRadioNetworking.ServerboundRegistry(){

            @Override
            public <P extends CustomPacket> void register(ResourceLocation id, Class<P> packetClass, FriendlyByteBuf.Reader<P> reader, BiConsumer<P, FriendlyByteBuf> writer, TriConsumer<P, MinecraftServer, ServerPlayer> handler) {
                CHANNEL.messageBuilder(packetClass, index.getAndIncrement()).decoder(reader).encoder(writer).consumerMainThread((packet, context) -> {
                    handler.accept(packet, (Object)((NetworkEvent.Context)context.get()).getSender().m_20194_(), (Object)((NetworkEvent.Context)context.get()).getSender());
                    ((NetworkEvent.Context)context.get()).setPacketHandled(true);
                }).add();
            }
        });
        SimpleRadioNetworking.loadClientbound(new SimpleRadioNetworking.ClientboundRegistry(){

            @Override
            public <P extends CustomPacket> void register(ResourceLocation id, Class<P> packetClass, FriendlyByteBuf.Reader<P> reader, BiConsumer<P, FriendlyByteBuf> writer, Consumer<P> handler) {
                CHANNEL.messageBuilder(packetClass, index.getAndIncrement()).decoder(reader).encoder(writer).consumerMainThread((packet, context) -> {
                    handler.accept(packet);
                    ((NetworkEvent.Context)context.get()).setPacketHandled(true);
                }).add();
            }
        });
    }

    public static void loadItems() {
    }

    public static void load() {
        ForgeLoader.loadItems();
        ForgeLoader.loadPackets();
    }

    public static void loadClient() {
    }
}

