/*
 * Decompiled with CFR 0.152.
 */
package com.codinglitch.simpleradio.client.core.registry.renderers;

import com.codinglitch.simpleradio.CommonSimpleRadio;
import com.codinglitch.simpleradio.SimpleRadioLibrary;
import com.codinglitch.simpleradio.client.ClientRadioManager;
import com.codinglitch.simpleradio.core.registry.SimpleRadioItems;
import com.codinglitch.simpleradio.core.registry.entities.Wire;
import com.codinglitch.simpleradio.radio.RadioManager;
import com.codinglitch.simpleradio.radio.RadioRouter;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Math;
import org.joml.Matrix4f;

public class WireRenderer
extends EntityRenderer<Wire> {
    private static final Vec3 UP = new Vec3(0.0, 1.0, 0.0);
    private static final Vec3 RIGHT = new Vec3(1.0, 0.0, 0.0);
    private static final float CABLE_SIZE = 0.05f;
    private static final float SEGMENTS = 24.0f;

    public WireRenderer(EntityRendererProvider.Context context) {
        super(context);
    }

    public static void renderWire(Level level, MultiBufferSource source, PoseStack poseStack, Vec3 from, Vec3 to, @Nullable Wire wire, float partialTick) {
        VertexConsumer consumer = source.m_6299_(RenderType.m_110446_((ResourceLocation)CommonSimpleRadio.id("textures/entity/wire.png")));
        Matrix4f matrix = poseStack.m_85850_().m_252922_();
        float distance = (float)to.m_82546_(from).m_82553_();
        Vec3 middle = from.m_165921_(to, 0.5).m_82492_(0.0, SimpleRadioLibrary.CLIENT_CONFIG.wire.baseSag + (double)distance * SimpleRadioLibrary.CLIENT_CONFIG.wire.distanceSag, 0.0);
        Vec3 lastTopLeft = null;
        Vec3 lastBottomLeft = null;
        Vec3 lastTopRight = null;
        Vec3 lastBottomRight = null;
        int fromSkyLight = level.m_45517_(LightLayer.SKY, BlockPos.m_274446_((Position)from));
        int toSkyLight = level.m_45517_(LightLayer.SKY, BlockPos.m_274446_((Position)to));
        int fromBlockLight = level.m_45517_(LightLayer.BLOCK, BlockPos.m_274446_((Position)from));
        int toBlockLight = level.m_45517_(LightLayer.BLOCK, BlockPos.m_274446_((Position)to));
        float tile = 0.0f;
        float vOffset = distance / 0.05f / 24.0f * 0.065f;
        int i = 0;
        while ((float)i <= 24.0f) {
            float progress = (float)i / 24.0f;
            float effector = 0.0f;
            if (wire != null && SimpleRadioLibrary.CLIENT_CONFIG.wire.effect.booleanValue()) {
                double effectDuration = distance * (float)SimpleRadioLibrary.CLIENT_CONFIG.wire.effectTime.intValue();
                for (Wire.Effect effect : wire.effectList) {
                    float effectProgress = (float)((double)((float)effect.progress + (float)effect.direction * partialTick) / effectDuration);
                    float effectDistance = Math.abs((float)(effectProgress - progress));
                    if (!(effectDistance <= 0.1f)) continue;
                    effector += (0.1f - effectDistance) * 10.0f;
                }
            }
            Vec3 fromMiddle = from.m_165921_(middle, (double)progress);
            Vec3 middleTo = middle.m_165921_(to, (double)progress);
            Vec3 segmentPosition = fromMiddle.m_165921_(middleTo, (double)progress);
            Vec3 direction = fromMiddle.m_165921_(middleTo, (double)(progress + 0.05f)).m_82546_(segmentPosition).m_82541_();
            Vec3 side = direction.m_82537_(direction.f_82480_ == -1.0 || direction.f_82480_ == 1.0 ? RIGHT : UP).m_82541_().m_82490_((double)0.025f);
            Vec3 up = side.m_82537_(direction).m_82541_().m_82490_((double)0.025f);
            Vec3 otherSide = side.m_82548_();
            Vec3 down = up.m_82548_();
            Vec3 topLeft = segmentPosition.m_82549_(otherSide).m_82549_(up);
            Vec3 bottomLeft = segmentPosition.m_82549_(otherSide).m_82549_(down);
            Vec3 topRight = segmentPosition.m_82549_(side).m_82549_(up);
            Vec3 bottomRight = segmentPosition.m_82549_(side).m_82549_(down);
            if (lastTopLeft != null) {
                int skyLight = (int)Mth.m_14179_((float)progress, (float)fromSkyLight, (float)toSkyLight);
                int blockLight = (int)Mth.m_14179_((float)Math.clamp((float)0.0f, (float)1.0f, (float)effector), (float)Mth.m_14179_((float)progress, (float)fromBlockLight, (float)toBlockLight), (float)15.0f);
                float newTile = vOffset + vOffset * 24.0f * progress;
                int overlay = Math.clamp((int)0, (int)10, (int)Math.round((float)(effector * 5.0f)));
                int packedLight = LightTexture.m_109885_((int)blockLight, (int)skyLight);
                WireRenderer.buildQuad(consumer, matrix, overlay, packedLight, up.m_82541_(), 0.0625f, vOffset, newTile, lastTopRight, topRight, topLeft, lastTopLeft);
                WireRenderer.buildQuad(consumer, matrix, overlay, packedLight, side.m_82541_(), 2.0f, vOffset, newTile, lastBottomRight, bottomRight, topRight, lastTopRight);
                WireRenderer.buildQuad(consumer, matrix, overlay, packedLight, down.m_82541_(), 1.1875f, vOffset, newTile, lastBottomLeft, bottomLeft, bottomRight, lastBottomRight);
                WireRenderer.buildQuad(consumer, matrix, overlay, packedLight, otherSide.m_82541_(), 3.25f, vOffset, newTile, lastTopLeft, topLeft, bottomLeft, lastBottomLeft);
            }
            lastTopLeft = topLeft;
            lastBottomLeft = bottomLeft;
            lastTopRight = topRight;
            lastBottomRight = bottomRight;
            ++i;
        }
    }

    public void render(Wire wire, float f, float partialTick, PoseStack poseStack, MultiBufferSource source, int i) {
        Optional<UUID> fromRef = wire.getFrom();
        Optional<UUID> toRef = wire.getTo();
        if (fromRef.isPresent()) {
            RadioRouter from = ClientRadioManager.getRouter(fromRef.get());
            if (from == null) {
                return;
            }
            if (toRef.isPresent()) {
                RadioRouter to = ClientRadioManager.getRouter(toRef.get());
                if (to == null) {
                    return;
                }
                Vec3 fromPosition = from.getConnectionPosition();
                Vec3 toPosition = to.getConnectionPosition();
                Vec3 offset = wire.m_20318_(partialTick);
                poseStack.m_85836_();
                poseStack.m_85837_(-offset.f_82479_, -offset.f_82480_, -offset.f_82481_);
                WireRenderer.renderWire(wire.m_9236_(), source, poseStack, fromPosition, toPosition, wire, partialTick);
                poseStack.m_85849_();
            }
        }
        super.m_7392_((Entity)wire, f, partialTick, poseStack, source, i);
    }

    public static void renderPlayer(AbstractClientPlayer player, MultiBufferSource source, PoseStack poseStack, float partialTick, @Nullable Camera camera) {
        CompoundTag tag;
        ItemStack wire = RadioManager.isEntityHolding((Entity)player, stack -> stack.m_150930_((Item)SimpleRadioItems.COPPER_WIRE));
        if (wire != null && (tag = wire.m_41784_()).m_128441_("connectTo")) {
            RadioRouter router = ClientRadioManager.getRouter(tag.m_128342_("connectTo"));
            if (router == null) {
                return;
            }
            ClientLevel level = player.f_108545_;
            Vec3 holdPosition = player.m_7398_(partialTick);
            Vec3 connectionPosition = router.getConnectionPosition();
            Vec3 offset = player.m_20318_(partialTick);
            poseStack.m_85836_();
            if (camera != null) {
                Vec3 cameraPos = camera.m_90583_();
                poseStack.m_85837_(-cameraPos.f_82479_, -cameraPos.f_82480_, -cameraPos.f_82481_);
                WireRenderer.renderWire((Level)level, source, poseStack, holdPosition, connectionPosition, null, partialTick);
            } else {
                poseStack.m_85837_(-offset.f_82479_, -offset.f_82480_, -offset.f_82481_);
                WireRenderer.renderWire((Level)level, source, poseStack, holdPosition, connectionPosition, null, partialTick);
            }
            poseStack.m_85849_();
        }
    }

    public static void buildQuad(VertexConsumer consumer, Matrix4f matrix, int overlay, int packedLight, Vec3 normal, float index, float offset, float tile, Vec3 one, Vec3 two, Vec3 three, Vec3 four) {
        consumer.m_252986_(matrix, (float)one.f_82479_, (float)one.f_82480_, (float)one.f_82481_).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(index, tile).m_86008_(OverlayTexture.m_118093_((int)overlay, (int)15)).m_85969_(packedLight).m_5601_((float)normal.f_82479_, (float)normal.f_82480_, (float)normal.f_82481_).m_5752_();
        consumer.m_252986_(matrix, (float)two.f_82479_, (float)two.f_82480_, (float)two.f_82481_).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(index, offset + tile).m_86008_(OverlayTexture.m_118093_((int)overlay, (int)15)).m_85969_(packedLight).m_5601_((float)normal.f_82479_, (float)normal.f_82480_, (float)normal.f_82481_).m_5752_();
        consumer.m_252986_(matrix, (float)three.f_82479_, (float)three.f_82480_, (float)three.f_82481_).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(index, offset + tile).m_86008_(OverlayTexture.m_118093_((int)overlay, (int)15)).m_85969_(packedLight).m_5601_((float)normal.f_82479_, (float)normal.f_82480_, (float)normal.f_82481_).m_5752_();
        consumer.m_252986_(matrix, (float)four.f_82479_, (float)four.f_82480_, (float)four.f_82481_).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(index, tile).m_86008_(OverlayTexture.m_118093_((int)overlay, (int)15)).m_85969_(packedLight).m_5601_((float)normal.f_82479_, (float)normal.f_82480_, (float)normal.f_82481_).m_5752_();
    }

    public ResourceLocation getTextureLocation(Wire wireEntity) {
        return null;
    }
}

