/*
 * Decompiled with CFR 0.152.
 */
package com.codinglitch.simpleradio.api.central;

import java.text.NumberFormat;
import java.util.Locale;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import org.joml.Math;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class WorldlyPosition
extends Vector3f {
    public Level level;
    private final BlockPos realLocation;

    public WorldlyPosition(float x, float y, float z, Level level, BlockPos realLocation) {
        super(x, y, z);
        this.level = level;
        this.realLocation = realLocation;
    }

    public WorldlyPosition(float x, float y, float z, Level level) {
        this(x, y, z, level, null);
    }

    public WorldlyPosition() {
        this(0.0f, 0.0f, 0.0f, null, null);
    }

    public static WorldlyPosition of(BlockPos pos, Level level, BlockPos realLocation) {
        return WorldlyPosition.of(pos.m_252807_().m_252839_(), level, realLocation);
    }

    public static WorldlyPosition of(BlockPos pos, Level level) {
        return WorldlyPosition.of(pos.m_252807_().m_252839_(), level);
    }

    public static WorldlyPosition of(Vector3f pos, Level level, BlockPos realLocation) {
        return new WorldlyPosition(pos.x, pos.y, pos.z, level, realLocation);
    }

    public static WorldlyPosition of(Vector3f pos, Level level) {
        return new WorldlyPosition(pos.x, pos.y, pos.z, level);
    }

    public Vector3f position() {
        return this;
    }

    public boolean equals(WorldlyPosition location) {
        if (location == null) {
            return false;
        }
        if (location.level == null) {
            return false;
        }
        if (this.level == null) {
            return false;
        }
        return location.level == this.level && location.position() == this.position();
    }

    public BlockPos blockPos() {
        return new BlockPos((int)Math.floor((float)this.x), (int)Math.floor((float)this.y), (int)Math.floor((float)this.z));
    }

    public BlockPos realLocation() {
        return this.realLocation == null ? this.blockPos() : this.realLocation;
    }

    public Vector3f dimensionScaled() {
        return this.position().mul((float)this.level.m_6042_().f_63859_(), new Vector3f());
    }

    public float distance(WorldlyPosition other) {
        return this.dimensionScaled().distance((Vector3fc)other.dimensionScaled());
    }

    public boolean isClientSide() {
        return this.level.f_46443_;
    }

    public String toString() {
        return this.toString(NumberFormat.getNumberInstance(Locale.ENGLISH));
    }
}

