/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.effect;

import io.redspace.ironsspellbooks.effect.MagicMobEffect;
import io.redspace.ironsspellbooks.registries.MobEffectRegistry;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingHealEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class BlightEffect
extends MagicMobEffect {
    public static final float DAMAGE_PER_LEVEL = -0.05f;
    public static final float HEALING_PER_LEVEL = -0.1f;

    public BlightEffect(MobEffectCategory pCategory, int pColor) {
        super(pCategory, pColor);
    }

    @SubscribeEvent
    public static void reduceHealing(LivingHealEvent event) {
        MobEffectInstance effect = event.getEntity().m_21124_((MobEffect)MobEffectRegistry.BLIGHT.get());
        if (effect != null) {
            int lvl = effect.m_19564_() + 1;
            float healingMult = 1.0f + -0.1f * (float)lvl;
            float before = event.getAmount();
            event.setAmount(event.getAmount() * healingMult);
        }
    }

    @SubscribeEvent
    public static void reduceDamageOutput(LivingDamageEvent event) {
        LivingEntity livingAttacker;
        MobEffectInstance effect;
        Entity attacker = event.getSource().m_7639_();
        if (attacker instanceof LivingEntity && (effect = (livingAttacker = (LivingEntity)attacker).m_21124_((MobEffect)MobEffectRegistry.BLIGHT.get())) != null) {
            int lvl = effect.m_19564_() + 1;
            float before = event.getAmount();
            float multiplier = 1.0f + -0.05f * (float)lvl;
            event.setAmount(event.getAmount() * multiplier);
        }
    }
}

