/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.queries.function.valuesource;

import guideme.internal.shaded.lucene.index.LeafReaderContext;
import guideme.internal.shaded.lucene.queries.function.FunctionValues;
import guideme.internal.shaded.lucene.queries.function.ValueSource;
import guideme.internal.shaded.lucene.queries.function.docvalues.BoolDocValues;
import guideme.internal.shaded.lucene.queries.function.valuesource.BoolFunction;
import guideme.internal.shaded.lucene.search.IndexSearcher;
import java.io.IOException;
import java.util.Map;

public abstract class SimpleBoolFunction
extends BoolFunction {
    protected final ValueSource source;

    public SimpleBoolFunction(ValueSource source) {
        this.source = source;
    }

    protected abstract String name();

    protected abstract boolean func(int var1, FunctionValues var2) throws IOException;

    @Override
    public BoolDocValues getValues(Map<Object, Object> context, LeafReaderContext readerContext) throws IOException {
        final FunctionValues vals = this.source.getValues(context, readerContext);
        return new BoolDocValues(this){

            @Override
            public boolean boolVal(int doc) throws IOException {
                return SimpleBoolFunction.this.func(doc, vals);
            }

            @Override
            public String toString(int doc) throws IOException {
                return SimpleBoolFunction.this.name() + "(" + vals.toString(doc) + ")";
            }
        };
    }

    @Override
    public String description() {
        return this.name() + "(" + this.source.description() + ")";
    }

    @Override
    public int hashCode() {
        return this.source.hashCode() + this.name().hashCode();
    }

    @Override
    public boolean equals(Object o) {
        if (this.getClass() != o.getClass()) {
            return false;
        }
        SimpleBoolFunction other = (SimpleBoolFunction)o;
        return this.source.equals(other.source);
    }

    @Override
    public void createWeight(Map<Object, Object> context, IndexSearcher searcher) throws IOException {
        this.source.createWeight(context, searcher);
    }
}

