/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.platforms.client.misc;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import shetiphian.platforms.common.tileentity.TileEntityPlatformBase;

public class TextureInfoHelper {
    public static final ItemStack DEFAULT_TEXTURE = new ItemStack((ItemLike)Blocks.f_50705_);

    public static List<Component> getHUD(TileEntityPlatformBase platform, boolean base) {
        ArrayList<Component> lines = new ArrayList<Component>();
        if (base || !platform.hasRail()) {
            if (platform.hasRail()) {
                lines.add((Component)Component.m_237115_((String)"info.platforms.base"));
            }
            TextureInfoHelper.addTextureInfo(lines, platform.getFrameTextureBlock());
            TextureInfoHelper.addTextureInfo(lines, platform.getCoverTextureBlock());
        } else if (platform.hasRail()) {
            lines.add((Component)Component.m_237115_((String)"info.platforms.addon"));
            TextureInfoHelper.addTextureInfo(lines, platform.getRailFrameTextureBlock());
            TextureInfoHelper.addTextureInfo(lines, platform.getRailCoverTextureBlock());
        }
        return lines;
    }

    private static void addTextureInfo(List<Component> lines, ItemStack stack) {
        if (!stack.m_41619_()) {
            lines.add((Component)Component.m_237113_((String)" * ").m_7220_((Component)Component.m_237115_((String)stack.m_41778_())));
        } else {
            TextureInfoHelper.addTextureError(lines, new String[0]);
        }
    }

    public static void addTextureInfo(List<Component> lines, CompoundTag tag, String textureKey) {
        if (tag.m_128441_(textureKey)) {
            CompoundTag itemNbt = tag.m_128469_(textureKey);
            ItemStack tagStack = ItemStack.m_41712_((CompoundTag)itemNbt);
            if (!tagStack.m_41619_()) {
                lines.add((Component)Component.m_237113_((String)" * ").m_7220_((Component)Component.m_237115_((String)tagStack.m_41778_())));
            } else {
                TextureInfoHelper.addTextureError(lines, itemNbt.m_128441_("id") ? itemNbt.m_128461_("id") : "");
            }
        } else {
            TextureInfoHelper.addTextureError(lines, new String[0]);
        }
    }

    public static void addTextureError(List<Component> lines, String ... invalid) {
        if (invalid.length == 0) {
            lines.add((Component)Component.m_237113_((String)" * \u26a0 ").m_7220_((Component)Component.m_237115_((String)"info.shetiphian.texture.missing")).m_130946_(" \u26a0"));
        } else {
            lines.add((Component)Component.m_237113_((String)" * \u26a0 ").m_7220_((Component)Component.m_237115_((String)"info.shetiphian.texture.invalid")).m_130946_(" \u26a0"));
            if (!Strings.isNullOrEmpty((String)invalid[0])) {
                lines.add((Component)Component.m_237113_((String)" ** ").m_7220_((Component)Component.m_237115_((String)invalid[0])));
            }
        }
        lines.add((Component)Component.m_237113_((String)" ** ").m_7220_((Component)Component.m_237115_((String)"info.shetiphian.texture.defaulted")).m_7220_((Component)Component.m_237113_((String)" ")).m_7220_((Component)Component.m_237115_((String)DEFAULT_TEXTURE.m_41778_())));
    }
}

