/*
 * Decompiled with CFR 0.152.
 */
package de.geheimagentnr1.dimension_access_manager.elements.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import de.geheimagentnr1.dimension_access_manager.config.ServerConfig;
import de.geheimagentnr1.dimension_access_manager.elements.commands.dimension.DimensionAccessTypeArgument;
import de.geheimagentnr1.dimension_access_manager.elements.commands.dimension.DimensionCommandAccessHelper;
import de.geheimagentnr1.minecraft_forge_api.elements.commands.CommandInterface;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;

public class DimensionsCommand
implements CommandInterface {
    @NotNull
    private final ServerConfig serverConfig;

    @NotNull
    public LiteralArgumentBuilder<CommandSourceStack> build() {
        LiteralArgumentBuilder dimensions = Commands.m_82127_((String)"dimensions");
        dimensions.then(Commands.m_82127_((String)"status").executes(this::showDimensionsStatus));
        dimensions.then(((LiteralArgumentBuilder)Commands.m_82127_((String)"default").requires(source -> source.m_6761_(3))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"defaultDimensionAccessType").executes(this::showDefaultDimensionAccessType)).then(Commands.m_82129_((String)"dimensionAccessType", (ArgumentType)DimensionAccessTypeArgument.dimensionAccessType()).executes(this::setDefaultDimensionAccessType))));
        return dimensions;
    }

    private int showDimensionsStatus(@NotNull CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        MinecraftServer server = source.m_81377_();
        server.m_129785_().forEach(serverLevel -> DimensionCommandAccessHelper.showDimensionStatus(source, serverLevel));
        return 1;
    }

    private int showDefaultDimensionAccessType(@NotNull CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        source.m_288197_(() -> Component.m_237113_((String)String.format("The default dimension access type is %s.", new Object[]{this.serverConfig.getDefaultDimensionAccessType()})), false);
        return 1;
    }

    private int setDefaultDimensionAccessType(@NotNull CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        this.serverConfig.setDefaultDimensionAccessType(DimensionAccessTypeArgument.getDimensionAccessType(context, "dimensionAccessType"));
        source.m_288197_(() -> Component.m_237113_((String)String.format("The default dimension access type is now %s.", new Object[]{this.serverConfig.getDefaultDimensionAccessType()})), true);
        return 1;
    }

    public DimensionsCommand(@NotNull ServerConfig serverConfig) {
        if (serverConfig == null) {
            throw new NullPointerException("serverConfig is marked non-null but is null");
        }
        this.serverConfig = serverConfig;
    }
}

