/*
 * Decompiled with CFR 0.152.
 */
package de.geheimagentnr1.dimension_access_manager.elements.capabilities.dimension_access_list;

import com.mojang.authlib.GameProfile;
import java.util.Comparator;
import java.util.TreeSet;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;

public abstract class DimensionAccessListCapability
implements ICapabilitySerializable<ListTag> {
    @NotNull
    private final LazyOptional<? extends DimensionAccessListCapability> holder = LazyOptional.of(() -> this);
    @NotNull
    private final TreeSet<GameProfile> gameProfiles = new TreeSet<GameProfile>(Comparator.comparing(GameProfile::getId));

    public boolean contains(@NotNull GameProfile gameProfile) {
        return this.gameProfiles.contains(gameProfile);
    }

    public boolean add(@NotNull GameProfile gameProfile) {
        return this.gameProfiles.add(gameProfile);
    }

    public boolean remove(@NotNull GameProfile gameProfile) {
        return this.gameProfiles.remove(gameProfile);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        return this.getCapability() == cap ? this.holder.cast() : LazyOptional.empty();
    }

    @NotNull
    protected abstract Capability<? extends DimensionAccessListCapability> getCapability();

    public ListTag serializeNBT() {
        ListTag listNBT = new ListTag();
        this.gameProfiles.forEach(gameProfile -> {
            CompoundTag compound = new CompoundTag();
            listNBT.add((Object)NbtUtils.m_129230_((CompoundTag)compound, (GameProfile)gameProfile));
        });
        return listNBT;
    }

    public void deserializeNBT(@NotNull ListTag nbt) {
        nbt.forEach(inbt -> {
            if (inbt.m_7060_() == 10) {
                this.gameProfiles.add(NbtUtils.m_129228_((CompoundTag)((CompoundTag)inbt)));
            }
        });
    }

    @NotNull
    public TreeSet<GameProfile> getGameProfiles() {
        return this.gameProfiles;
    }
}

