/*
 * Decompiled with CFR 0.152.
 */
package de.geheimagentnr1.dimension_access_manager.config;

import de.geheimagentnr1.dimension_access_manager.elements.capabilities.dimension_access.DimensionAccessType;
import de.geheimagentnr1.minecraft_forge_api.AbstractMod;
import de.geheimagentnr1.minecraft_forge_api.config.AbstractConfig;
import net.minecraftforge.fml.config.ModConfig;
import org.jetbrains.annotations.NotNull;

public class ServerConfig
extends AbstractConfig {
    @NotNull
    private static final String DEFAULT_DIMENSION_ACCESS_TYPE_KEY = "default_dimension_access_type";
    @NotNull
    private static final String DIMENSION_COMMAND_PERMISSION_LEVEL_KEY = "dimension_command_permission_level";

    public ServerConfig(@NotNull AbstractMod _abstractMod) {
        super(_abstractMod);
    }

    @NotNull
    public ModConfig.Type type() {
        return ModConfig.Type.SERVER;
    }

    public boolean isEarlyLoad() {
        return false;
    }

    protected void registerConfigValues() {
        this.registerConfigValue("Defines if new dimensions are GRANTED or LOCKED by default.", DEFAULT_DIMENSION_ACCESS_TYPE_KEY, (builder, path) -> builder.defineEnum(path, (Enum)DimensionAccessType.GRANTED));
        this.registerConfigValue("Defines which permission level is required to run the /dimension command", DIMENSION_COMMAND_PERMISSION_LEVEL_KEY, (builder, path) -> builder.defineInRange(path, 3, 0, 4));
    }

    @NotNull
    public DimensionAccessType getDefaultDimensionAccessType() {
        return (DimensionAccessType)((Object)this.getValue(DimensionAccessType.class, DEFAULT_DIMENSION_ACCESS_TYPE_KEY));
    }

    public void setDefaultDimensionAccessType(@NotNull DimensionAccessType _defaultDimensionAccessType) {
        this.setValue(DimensionAccessType.class, DEFAULT_DIMENSION_ACCESS_TYPE_KEY, (Object)_defaultDimensionAccessType);
    }

    @NotNull
    public Integer getDimensionCommandPermissionLevel() {
        return (Integer)this.getValue(Integer.class, DIMENSION_COMMAND_PERMISSION_LEVEL_KEY);
    }
}

