/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.sushigocrafting.tile.machinery;

import com.buuz135.sushigocrafting.api.IFoodIngredient;
import com.buuz135.sushigocrafting.api.IFoodType;
import com.buuz135.sushigocrafting.api.impl.FoodAPI;
import com.buuz135.sushigocrafting.api.impl.FoodHelper;
import com.buuz135.sushigocrafting.cap.SushiWeightDiscoveryCapability;
import com.buuz135.sushigocrafting.client.gui.RollerWeightSelectorButtonComponent;
import com.buuz135.sushigocrafting.client.gui.provider.RollerAssetProvider;
import com.buuz135.sushigocrafting.component.FoodTypeButtonComponent;
import com.buuz135.sushigocrafting.component.RollerCraftButtonComponent;
import com.buuz135.sushigocrafting.item.FoodItem;
import com.buuz135.sushigocrafting.proxy.SushiContent;
import com.hrznstudio.titanium.annotation.Save;
import com.hrznstudio.titanium.block.BasicTileBlock;
import com.hrznstudio.titanium.block.tile.ActiveTile;
import com.hrznstudio.titanium.client.screen.asset.IAssetProvider;
import com.hrznstudio.titanium.component.inventory.InventoryComponent;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.items.ItemHandlerHelper;

public class RollerTile
extends ActiveTile<RollerTile> {
    @Save
    private final InventoryComponent<RollerTile> slots;
    @Save
    private String selected;
    @Save
    private final WeightTracker weightTracker;
    @Save
    private int craftProgress;
    @Save
    private final InventoryComponent<RollerTile> spices;

    public RollerTile(BlockPos pos, BlockState state) {
        super((BasicTileBlock)SushiContent.Blocks.ROLLER.get(), (BlockEntityType)SushiContent.TileEntities.ROLLER.get(), pos, state);
        int i = 0;
        int max = 0;
        this.craftProgress = 0;
        for (IFoodType foodType : FoodAPI.get().getFoodTypes()) {
            if (this.selected == null) {
                this.selected = foodType.getName();
            }
            max = Math.max(max, foodType.getFoodIngredients().size());
            ++i;
        }
        this.weightTracker = new WeightTracker(max);
        this.slots = new InventoryComponent("slots", 0, 0, max).setSlotPosition(FoodAPI.get().getTypeFromName(this.selected).get().getSlotPosition()).setInputFilter((stack, integer) -> {
            List<IFoodIngredient[]> ingredients = FoodAPI.get().getTypeFromName(this.selected).get().getFoodIngredients();
            if (integer >= ingredients.size()) {
                return false;
            }
            for (IFoodIngredient ingredient : ingredients.get((int)integer)) {
                if (ingredient.isEmpty() || !ingredient.getItem().equals(stack.m_41720_())) continue;
                return true;
            }
            return false;
        });
        this.addInventory(this.slots);
        this.spices = new InventoryComponent("spices", 130, 76, 2).setSlotLimit(1).setSlotToColorRender(0, DyeColor.YELLOW).setSlotToColorRender(1, DyeColor.YELLOW).setSlotToItemStackRender(0, new ItemStack((ItemLike)SushiContent.Items.SOY_SAUCE.get())).setSlotToItemStackRender(1, new ItemStack((ItemLike)SushiContent.Items.WASABI_PASTE.get())).setInputFilter((stack, integer) -> {
            if (integer == 0) {
                return stack.m_41720_().equals(SushiContent.Items.SOY_SAUCE.get());
            }
            if (integer == 1) {
                return stack.m_41720_().equals(SushiContent.Items.WASABI_PASTE.get());
            }
            return false;
        });
        this.addInventory(this.spices);
        this.addInventory(this.spices);
        FoodAPI.get().getTypeFromName(this.selected).ifPresent(iFoodType -> {
            for (int slot = 0; slot < this.slots.getSlots(); ++slot) {
                this.slots.setSlotToItemStackRender(slot, iFoodType.getSlotStackRender().apply(slot));
                this.slots.setSlotToColorRender(slot, 16762729);
            }
        });
    }

    @OnlyIn(value=Dist.CLIENT)
    public void initClient() {
        super.initClient();
        int i = 0;
        for (IFoodType foodType : FoodAPI.get().getFoodTypes()) {
            this.addButton(new FoodTypeButtonComponent(foodType, -20, i * 20 + 10, 18, 18){

                @Override
                public Supplier<String> getSelected() {
                    return () -> RollerTile.this.selected;
                }
            }.setComponent(this::getSlots));
            ++i;
        }
        FoodAPI.get().getTypeFromName(this.selected).ifPresent(iFoodType -> {
            int i1 = 0;
            while (i1 < this.slots.getSlots()) {
                final int finalI = i1++;
                this.addGuiAddonFactory(() -> new RollerWeightSelectorButtonComponent(this.slots, finalI){

                    @Override
                    public int getWeight() {
                        return RollerTile.this.weightTracker.weights.get(finalI);
                    }

                    @Override
                    public String getType() {
                        return RollerTile.this.selected;
                    }
                });
            }
        });
        this.addButton(new RollerCraftButtonComponent(148, 20, 18, 18).setId(101));
    }

    public InteractionResult onActivated(Player player, InteractionHand hand, Direction facing, double hitX, double hitY, double hitZ) {
        InteractionResult type = super.onActivated(player, hand, facing, hitX, hitY, hitZ);
        if (!type.m_19080_()) {
            if (player instanceof ServerPlayer) {
                player.getCapability(SushiWeightDiscoveryCapability.CAPABILITY).ifPresent(iSushiWeightDiscovery -> iSushiWeightDiscovery.requestUpdate((ServerPlayer)player, ItemStack.f_41583_));
            }
            this.openGui(player);
            return InteractionResult.SUCCESS;
        }
        return type;
    }

    public void onClick(Player player) {
        if (this.isServer()) {
            FoodAPI.get().getTypeFromName(this.selected).ifPresent(iFoodType -> {
                boolean allFull = true;
                for (int i1 = 0; i1 < this.slots.getSlots(); ++i1) {
                    IFoodIngredient ingredient;
                    if (i1 >= iFoodType.getFoodIngredients().size() || (ingredient = FoodAPI.get().getIngredientFromItem(this.slots.getStackInSlot(i1).m_41720_())).isEmpty() || ingredient.getIngredientConsumer().canConsume(ingredient, this.slots.getStackInSlot(i1), this.weightTracker.weights.get(i1))) continue;
                    allFull = false;
                    break;
                }
                if (allFull) {
                    ++this.craftProgress;
                    if (this.craftProgress >= 4) {
                        Random random = new Random(((ServerLevel)this.f_58857_).m_7328_() + (long)this.selected.hashCode());
                        this.craftProgress = 0;
                        ArrayList<IFoodIngredient> foodIngredients = new ArrayList<IFoodIngredient>();
                        ArrayList<Integer> weightValues = new ArrayList<Integer>();
                        AtomicReference<ItemStack> discovery = new AtomicReference<ItemStack>(ItemStack.f_41583_);
                        for (int slot = 0; slot < this.slots.getSlots(); ++slot) {
                            if (slot >= iFoodType.getFoodIngredients().size()) continue;
                            IFoodIngredient ingredient = FoodAPI.get().getIngredientFromItem(this.slots.getStackInSlot(slot).m_41720_());
                            foodIngredients.add(ingredient);
                        }
                        FoodItem item = FoodHelper.getFoodFromIngredients(this.selected, foodIngredients);
                        if (item != null) {
                            ItemStack stack = new ItemStack((ItemLike)item);
                            for (int slot = 0; slot < this.slots.getSlots(); ++slot) {
                                if (slot >= iFoodType.getFoodIngredients().size()) continue;
                                IFoodIngredient ingredient = (IFoodIngredient)foodIngredients.get(slot);
                                ingredient.getIngredientConsumer().consume(ingredient, this.slots.getStackInSlot(slot), this.weightTracker.weights.get(slot));
                                int value = random.nextInt(5) - this.weightTracker.weights.get(slot);
                                weightValues.add(value);
                                if (value != 0 || ingredient.isEmpty()) continue;
                                int finalSlot = slot;
                                player.getCapability(SushiWeightDiscoveryCapability.CAPABILITY).ifPresent(iSushiWeightDiscovery -> {
                                    if (!iSushiWeightDiscovery.hasDiscovery(this.selected + "-" + finalSlot)) {
                                        iSushiWeightDiscovery.setDiscovery(this.selected + "-" + finalSlot, this.weightTracker.weights.get(finalSlot));
                                        discovery.set(stack.m_41777_());
                                    }
                                });
                            }
                            stack.m_41784_().m_128408_("Weights", weightValues);
                            CompoundTag spicesNBT = new CompoundTag();
                            for (int i = 0; i < this.spices.getSlots(); ++i) {
                                IFoodIngredient soy;
                                if (this.spices.getStackInSlot(i).m_41619_() || !(soy = FoodAPI.get().getIngredientFromItem(this.spices.getStackInSlot(i).m_41720_())).getIngredientConsumer().canConsume(soy, this.spices.getStackInSlot(i), 0)) continue;
                                soy.getIngredientConsumer().consume(soy, this.spices.getStackInSlot(i), 0);
                                spicesNBT.m_128379_(soy.getName(), true);
                            }
                            stack.m_41784_().m_128365_("Spices", (Tag)spicesNBT);
                            Containers.m_18992_((Level)this.f_58857_, (double)this.f_58858_.m_123341_(), (double)this.m_58899_().m_123342_(), (double)this.m_58899_().m_123343_(), (ItemStack)stack);
                        }
                        if (player instanceof ServerPlayer) {
                            player.getCapability(SushiWeightDiscoveryCapability.CAPABILITY).ifPresent(iSushiWeightDiscovery -> iSushiWeightDiscovery.requestUpdate((ServerPlayer)player, (ItemStack)discovery.get()));
                        }
                        this.markForUpdate();
                    }
                }
            });
        }
    }

    public void handleButtonMessage(int id, Player playerEntity, CompoundTag compound) {
        super.handleButtonMessage(id, playerEntity, compound);
        if (compound.m_128441_("Type")) {
            FoodAPI.get().getTypeFromName(compound.m_128461_("Type")).ifPresent(iFoodType -> {
                int i;
                ItemStack slotStack;
                this.slots.setSlotPosition(iFoodType.getSlotPosition());
                for (int i1 = 0; i1 < this.slots.getSlots(); ++i1) {
                    if (i1 < iFoodType.getFoodIngredients().size()) {
                        this.slots.setSlotLimit(i1, 64);
                        continue;
                    }
                    slotStack = this.slots.getStackInSlot(i1).m_41777_();
                    this.slots.setStackInSlot(i1, ItemStack.f_41583_);
                    this.slots.setSlotLimit(i1, 0);
                    ItemHandlerHelper.giveItemToPlayer((Player)playerEntity, (ItemStack)slotStack);
                }
                this.selected = compound.m_128461_("Type");
                for (i = 0; i < this.slots.getSlots(); ++i) {
                    this.slots.setSlotToItemStackRender(i, iFoodType.getSlotStackRender().apply(i));
                }
                this.syncObject(this.slots);
                for (i = 0; i < this.slots.getSlots(); ++i) {
                    if (this.slots.isItemValid(i, this.slots.getStackInSlot(i))) continue;
                    slotStack = this.slots.getStackInSlot(i).m_41777_();
                    this.slots.setStackInSlot(i, ItemStack.f_41583_);
                    ItemHandlerHelper.giveItemToPlayer((Player)playerEntity, (ItemStack)slotStack);
                }
                this.markForUpdate();
            });
        }
        if (id == 100) {
            int weight = compound.m_128451_("WeightSlot");
            int button = compound.m_128451_("Button");
            if (button == 0) {
                this.weightTracker.weights.set(weight, Math.min(4, this.weightTracker.weights.get(weight) + 1));
            }
            if (button == 1) {
                this.weightTracker.weights.set(weight, Math.max(0, this.weightTracker.weights.get(weight) - 1));
            }
            this.syncObject(this.weightTracker);
        }
        if (id == 101) {
            int amount = 1;
            if (compound.m_128441_("Button")) {
                amount = compound.m_128451_("Button") == 1 ? 64 : 1;
            }
            for (int i = 0; i < amount; ++i) {
                this.craftProgress = 4;
                this.onClick(playerEntity);
            }
        }
    }

    public RollerTile getSelf() {
        return this;
    }

    public InventoryComponent<RollerTile> getSlots() {
        return this.slots;
    }

    public IAssetProvider getAssetProvider() {
        return RollerAssetProvider.INSTANCE;
    }

    public WeightTracker getWeightTracker() {
        return this.weightTracker;
    }

    public InventoryComponent<RollerTile> getSpices() {
        return this.spices;
    }

    public class WeightTracker
    implements INBTSerializable<CompoundTag> {
        private List<Integer> weights = new ArrayList<Integer>();

        public WeightTracker(int amount) {
            for (int i = 0; i < amount; ++i) {
                this.weights.add(0);
            }
        }

        public CompoundTag serializeNBT() {
            CompoundTag compoundNBT = new CompoundTag();
            compoundNBT.m_128408_("Weights", this.weights);
            return compoundNBT;
        }

        public void deserializeNBT(CompoundTag nbt) {
            this.weights = new ArrayList<Integer>();
            for (int i : nbt.m_128465_("Weights")) {
                this.weights.add(i);
            }
        }

        public List<Integer> getWeights() {
            return this.weights;
        }
    }
}

