/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.sushigocrafting.item;

import com.buuz135.sushigocrafting.api.IFoodIngredient;
import com.buuz135.sushigocrafting.api.IFoodType;
import com.buuz135.sushigocrafting.api.IIngredientEffect;
import com.buuz135.sushigocrafting.api.impl.FoodAPI;
import com.buuz135.sushigocrafting.api.impl.effect.ModifyIngredientEffect;
import com.buuz135.sushigocrafting.item.SushiItem;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class FoodItem
extends SushiItem {
    public static final String WEIGHTS_TAG = "Weights";
    public static final String SPICES_TAG = "Spices";
    private final List<IFoodIngredient> ingredientList;
    private final IFoodType type;

    public FoodItem(Item.Properties properties, IFoodType type) {
        super(properties.m_41489_(new FoodProperties.Builder().m_38767_()), type.getName());
        this.type = type;
        this.ingredientList = new ArrayList<IFoodIngredient>();
    }

    public static String getWeightText(int weight) {
        if (weight < 0) {
            return (weight == -1 ? ChatFormatting.RED : ChatFormatting.DARK_RED) + "\u25be";
        }
        if (weight > 0) {
            return (weight == 1 ? ChatFormatting.RED : ChatFormatting.DARK_RED) + "\u25b4";
        }
        return ChatFormatting.GOLD + "\uff65";
    }

    public static List<Component> getTagsFrom(int negative, int positive) {
        ArrayList<Component> names = new ArrayList<Component>();
        if (negative == 0 && positive == 0) {
            names.add((Component)Component.m_237113_((String)(ChatFormatting.GOLD + "Perfect")));
        } else if (Math.abs(negative) == positive) {
            names.add((Component)Component.m_237113_((String)(ChatFormatting.DARK_GREEN + "Weirdly Balanced")));
        }
        if (Math.abs(negative) < positive) {
            names.add((Component)Component.m_237113_((String)(ChatFormatting.RED + "Almost Hollow")));
        }
        if (Math.abs(negative) > positive) {
            names.add((Component)Component.m_237113_((String)(ChatFormatting.RED + "Overflowing")));
        }
        return names;
    }

    public static ModifyIngredientEffect getModifierFrom(int negative, int positive) {
        if (negative == 0 && positive == 0) {
            return new ModifyIngredientEffect(2.0f, 1);
        }
        if (Math.abs(negative) == positive) {
            return new ModifyIngredientEffect(1.2f, 0);
        }
        if (Math.abs(negative) < positive) {
            return new ModifyIngredientEffect(0.8f, 0);
        }
        if (Math.abs(negative) > positive) {
            return new ModifyIngredientEffect(0.8f, 0);
        }
        return new ModifyIngredientEffect(1.0f, 0);
    }

    public static float getFoodModifierValue(int negative, int positive) {
        if (negative == 0 && positive == 0) {
            return 1.25f;
        }
        if (Math.abs(negative) == positive) {
            return 0.9f;
        }
        return 0.8f;
    }

    public List<IFoodIngredient> getIngredientList() {
        return this.ingredientList;
    }

    public IFoodType getType() {
        return this.type;
    }

    public void m_7373_(ItemStack stack, Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_7373_(stack, worldIn, tooltip, flagIn);
        tooltip.add((Component)Component.m_237113_((String)(ChatFormatting.GRAY + "Ingredients: ")));
        for (int i = 0; i < this.ingredientList.size(); ++i) {
            if (this.ingredientList.get(i).isEmpty()) continue;
            Object line = ChatFormatting.GRAY + " - " + Component.m_237115_((String)this.ingredientList.get(i).getItem().m_5524_()).getString();
            if (stack.m_41782_()) {
                line = (String)line + " " + FoodItem.getWeightText(stack.m_41783_().m_128465_(WEIGHTS_TAG)[i]);
            }
            tooltip.add((Component)Component.m_237113_((String)line));
        }
        if (stack.m_41782_() && stack.m_41737_(SPICES_TAG) != null) {
            CompoundTag compoundNBT = stack.m_41737_(SPICES_TAG);
            for (String name : compoundNBT.m_128431_()) {
                IFoodIngredient foodIngredient = FoodAPI.get().getIngredientFromName(name);
                if (foodIngredient.isEmpty()) continue;
                tooltip.add((Component)Component.m_237113_((String)(ChatFormatting.GRAY + " - " + Component.m_237115_((String)foodIngredient.getItem().m_5524_()).getString())));
            }
        }
        boolean hasShift = Screen.m_96638_();
        boolean hasAlt = Screen.m_96639_();
        Info info = new Info(stack, hasShift);
        tooltip.addAll(FoodItem.getTagsFrom(info.getNegative(), info.getPositive()));
        tooltip.add((Component)Component.m_237113_((String)""));
        if (hasShift) {
            if (info.getEffectInstances().size() > 0) {
                tooltip.add((Component)Component.m_237113_((String)(ChatFormatting.DARK_AQUA + "Effects:")));
                if (hasAlt) {
                    tooltip.add((Component)Component.m_237113_((String)(ChatFormatting.YELLOW + " - " + ChatFormatting.GOLD + "Hunger: " + ChatFormatting.WHITE + (int)info.getHunger())));
                    tooltip.add((Component)Component.m_237113_((String)(ChatFormatting.YELLOW + " - " + ChatFormatting.GOLD + "Saturation: " + ChatFormatting.WHITE + info.getSaturation())));
                }
                info.getEffectInstances().forEach(effectInstance -> tooltip.add((Component)Component.m_237113_((String)(ChatFormatting.YELLOW + " - " + ChatFormatting.GOLD + effectInstance.m_19544_().m_19482_().getString() + ChatFormatting.DARK_AQUA + " (" + ChatFormatting.WHITE + effectInstance.m_19557_() / 20 + ChatFormatting.YELLOW + "s" + ChatFormatting.DARK_AQUA + ", " + ChatFormatting.YELLOW + "Level " + ChatFormatting.WHITE + (effectInstance.m_19564_() + 1) + ChatFormatting.DARK_AQUA + ")"))));
            }
        } else {
            tooltip.add((Component)Component.m_237113_((String)(ChatFormatting.YELLOW + "Hold " + ChatFormatting.GOLD + ChatFormatting.ITALIC + "<Shift>" + ChatFormatting.RESET + ChatFormatting.YELLOW + " for sushi effect")));
        }
    }

    public ItemStack m_5922_(ItemStack stack, Level worldIn, LivingEntity entity) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            Info info = new Info(stack, true);
            player.m_36324_().m_38707_((int)info.getHunger(), info.getSaturation());
            info.getEffectInstances().forEach(arg_0 -> ((Player)player).m_7292_(arg_0));
            worldIn.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), entity.m_7866_(stack), SoundSource.NEUTRAL, 1.0f, 1.0f + (worldIn.f_46441_.m_188501_() - worldIn.f_46441_.m_188501_()) * 0.4f);
            if (!(entity instanceof Player) || !((Player)entity).m_150110_().f_35937_) {
                stack.m_41774_(1);
            }
            return stack;
        }
        return entity.m_5584_(worldIn, stack);
    }

    @Nullable
    public FoodProperties getFoodProperties(ItemStack stack, @Nullable LivingEntity entity) {
        Info info = new Info(stack, true);
        return new FoodProperties.Builder().m_38760_((int)Math.floor(info.getHunger())).m_38758_(info.getSaturation()).m_38767_();
    }

    public static class Info {
        private final ItemStack stack;
        private final List<MobEffectInstance> effectInstances;
        private ModifyIngredientEffect modifyIngredientEffect;
        private int positive;
        private int negative = 0;
        private final float saturation;
        private final float hunger;

        public Info(ItemStack stack, boolean calculateEffects) {
            this.stack = stack;
            this.effectInstances = new ArrayList<MobEffectInstance>();
            this.modifyIngredientEffect = null;
            if (stack.m_41782_()) {
                for (int i : stack.m_41783_().m_128465_(FoodItem.WEIGHTS_TAG)) {
                    if (i < 0) {
                        this.negative += i;
                    }
                    if (i <= 0) continue;
                    this.positive += i;
                }
                this.modifyIngredientEffect = FoodItem.getModifierFrom(this.negative, this.positive);
            }
            FoodItem foodItem = (FoodItem)stack.m_41720_();
            this.hunger = (float)foodItem.getIngredientList().stream().map(IFoodIngredient::getHungerValue).mapToInt(Integer::intValue).sum() * FoodItem.getFoodModifierValue(this.negative, this.positive);
            this.saturation = (float)foodItem.getIngredientList().stream().map(IFoodIngredient::getSaturationValue).mapToInt(Integer::intValue).sum() * FoodItem.getFoodModifierValue(this.negative, this.positive) / (float)(foodItem.ingredientList.size() + 2);
            if (calculateEffects) {
                ArrayList<IFoodIngredient> foodIngredients = new ArrayList<IFoodIngredient>(foodItem.getIngredientList());
                if (stack.m_41782_() && stack.m_41737_(FoodItem.SPICES_TAG) != null) {
                    CompoundTag compoundNBT = stack.m_41737_(FoodItem.SPICES_TAG);
                    for (String name : compoundNBT.m_128431_()) {
                        IFoodIngredient foodIngredient = FoodAPI.get().getIngredientFromName(name);
                        if (foodIngredient.isEmpty()) continue;
                        foodIngredients.add(foodIngredient);
                    }
                }
                foodIngredients.stream().map(IFoodIngredient::getEffect).filter(Objects::nonNull).sorted(Comparator.comparingInt(IIngredientEffect::getPriority)).forEach(iIngredientEffect -> iIngredientEffect.accept(this.effectInstances));
                if (this.modifyIngredientEffect != null) {
                    this.modifyIngredientEffect.accept(this.effectInstances);
                }
            }
        }

        public ItemStack getStack() {
            return this.stack;
        }

        public List<MobEffectInstance> getEffectInstances() {
            return this.effectInstances;
        }

        public ModifyIngredientEffect getModifyIngredientEffect() {
            return this.modifyIngredientEffect;
        }

        public int getPositive() {
            return this.positive;
        }

        public int getNegative() {
            return this.negative;
        }

        public float getSaturation() {
            return this.saturation;
        }

        public float getHunger() {
            return this.hunger;
        }
    }
}

