/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.sushigocrafting.block.plant;

import com.buuz135.sushigocrafting.block.SushiGoCraftingBlock;
import com.buuz135.sushigocrafting.proxy.SushiContent;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.IForgeShearable;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.registries.ForgeRegistries;

public class AvocadoLeavesBlock
extends SushiGoCraftingBlock
implements IForgeShearable,
BonemealableBlock {
    public static final IntegerProperty DISTANCE = BlockStateProperties.f_61414_;
    public static final BooleanProperty PERSISTENT = BlockStateProperties.f_61447_;
    public static final IntegerProperty STAGE = IntegerProperty.m_61631_((String)"stage", (int)0, (int)2);

    public AvocadoLeavesBlock() {
        super("avocado_leaves", BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50050_));
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)DISTANCE, (Comparable)Integer.valueOf(7))).m_61124_((Property)PERSISTENT, (Comparable)Boolean.valueOf(false))).m_61124_((Property)STAGE, (Comparable)Integer.valueOf(0)));
    }

    private static BlockState updateDistance(BlockState state, LevelAccessor worldIn, BlockPos pos) {
        int i = 7;
        BlockPos.MutableBlockPos blockpos$mutable = new BlockPos.MutableBlockPos();
        for (Direction direction : Direction.values()) {
            blockpos$mutable.m_122159_((Vec3i)pos, direction);
            i = Math.min(i, AvocadoLeavesBlock.getDistance(worldIn.m_8055_((BlockPos)blockpos$mutable)) + 1);
            if (i == 1) break;
        }
        return (BlockState)state.m_61124_((Property)DISTANCE, (Comparable)Integer.valueOf(i));
    }

    private static int getDistance(BlockState neighbor) {
        if (ForgeRegistries.BLOCKS.tags().getTag(BlockTags.f_13106_).contains((Object)neighbor.m_60734_())) {
            return 0;
        }
        return neighbor.m_60734_() instanceof AvocadoLeavesBlock || neighbor.m_60734_() instanceof LeavesBlock ? (Integer)neighbor.m_61143_((Property)DISTANCE) : 7;
    }

    public VoxelShape m_7947_(BlockState state, BlockGetter reader, BlockPos pos) {
        return Shapes.m_83040_();
    }

    public boolean m_6724_(BlockState state) {
        return (Integer)state.m_61143_((Property)DISTANCE) == 7 && (Boolean)state.m_61143_((Property)PERSISTENT) == false || (Integer)state.m_61143_((Property)STAGE) == 1;
    }

    public void m_213898_(BlockState state, ServerLevel worldIn, BlockPos pos, RandomSource random) {
        worldIn.m_7731_(pos, AvocadoLeavesBlock.updateDistance(state, (LevelAccessor)worldIn, pos), 3);
        state = worldIn.m_8055_(pos);
        if (!((Boolean)state.m_61143_((Property)PERSISTENT)).booleanValue() && (Integer)state.m_61143_((Property)DISTANCE) == 7) {
            AvocadoLeavesBlock.m_49950_((BlockState)state, (Level)worldIn, (BlockPos)pos);
            worldIn.m_7471_(pos, false);
        }
        if ((Integer)state.m_61143_((Property)STAGE) == 1 && random.m_188503_(3) == 0) {
            worldIn.m_46597_(pos, (BlockState)state.m_61124_((Property)STAGE, (Comparable)Integer.valueOf(2)));
        }
    }

    public void m_213897_(BlockState state, ServerLevel worldIn, BlockPos pos, RandomSource rand) {
        worldIn.m_7731_(pos, AvocadoLeavesBlock.updateDistance(state, (LevelAccessor)worldIn, pos), 3);
    }

    public int m_7753_(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return 1;
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        int i = AvocadoLeavesBlock.getDistance(facingState) + 1;
        if (i != 1 || (Integer)stateIn.m_61143_((Property)DISTANCE) != i) {
            worldIn.m_186460_(currentPos, (Block)this, 1);
        }
        return stateIn;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void animateTick(BlockState stateIn, Level worldIn, BlockPos pos, Random rand) {
        BlockPos blockpos;
        BlockState blockstate;
        if (!(!worldIn.m_46758_(pos.m_7494_()) || rand.nextInt(15) != 1 || (blockstate = worldIn.m_8055_(blockpos = pos.m_7495_())).m_60815_() && blockstate.m_60783_((BlockGetter)worldIn, blockpos, Direction.UP))) {
            double d0 = (double)pos.m_123341_() + rand.nextDouble();
            double d1 = (double)pos.m_123342_() - 0.05;
            double d2 = (double)pos.m_123343_() + rand.nextDouble();
            worldIn.m_7106_((ParticleOptions)ParticleTypes.f_123803_, d0, d1, d2, 0.0, 0.0, 0.0);
        }
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{DISTANCE, PERSISTENT, STAGE});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return AvocadoLeavesBlock.updateDistance((BlockState)this.m_49966_().m_61124_((Property)PERSISTENT, (Comparable)Boolean.valueOf(true)), (LevelAccessor)context.m_43725_(), context.m_8083_());
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        if ((Integer)state.m_61143_((Property)STAGE) == 2) {
            ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)new ItemStack((ItemLike)SushiContent.Items.AVOCADO.get()));
            worldIn.m_46597_(pos, (BlockState)state.m_61124_((Property)STAGE, (Comparable)Integer.valueOf(1)));
            return InteractionResult.SUCCESS;
        }
        return super.m_6227_(state, worldIn, pos, player, handIn, hit);
    }

    public boolean m_7370_(LevelReader p_256559_, BlockPos p_50898_, BlockState state, boolean p_50900_) {
        return (Integer)state.m_61143_((Property)STAGE) > 0;
    }

    public boolean m_214167_(Level worldIn, RandomSource rand, BlockPos pos, BlockState state) {
        return (Integer)state.m_61143_((Property)STAGE) == 1;
    }

    public void m_214148_(ServerLevel worldIn, RandomSource rand, BlockPos pos, BlockState state) {
        worldIn.m_46597_(pos, (BlockState)state.m_61124_((Property)STAGE, (Comparable)Integer.valueOf(2)));
    }
}

