/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.rhino;

import dev.latvian.mods.rhino.Context;
import dev.latvian.mods.rhino.InterfaceAdapter;
import dev.latvian.mods.rhino.Scriptable;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Proxy;

public class VMBridge {
    public static boolean tryToMakeAccessible(Object target, AccessibleObject accessible) {
        if (accessible.canAccess(target)) {
            return true;
        }
        try {
            accessible.setAccessible(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return accessible.canAccess(target);
    }

    public static Object getInterfaceProxyHelper(Context cx, Class<?>[] interfaces) {
        Constructor<?> c;
        ClassLoader loader = interfaces[0].getClassLoader();
        Class<?> cl = Proxy.getProxyClass(loader, interfaces);
        try {
            c = cl.getConstructor(InvocationHandler.class);
        }
        catch (NoSuchMethodException ex) {
            throw new IllegalStateException(ex);
        }
        return c;
    }

    public static Object newInterfaceProxy(Object proxyHelper, InterfaceAdapter adapter, Object target, Scriptable topScope, Context cx) {
        Object proxy2;
        Constructor c = (Constructor)proxyHelper;
        InvocationHandler handler = (proxy, method, args) -> {
            if (method.getDeclaringClass() == Object.class) {
                String methodName = method.getName();
                if (methodName.equals("equals")) {
                    Object other = args[0];
                    return proxy == other;
                }
                if (methodName.equals("hashCode")) {
                    return target.hashCode();
                }
                if (methodName.equals("toString")) {
                    return "Proxy[" + target.toString() + "]";
                }
            }
            if (method.isDefault()) {
                return InvocationHandler.invokeDefault(proxy, method, args);
            }
            return adapter.invoke(cx, target, topScope, proxy, method, args);
        };
        try {
            proxy2 = c.newInstance(handler);
        }
        catch (InvocationTargetException ex) {
            throw Context.throwAsScriptRuntimeEx(ex, cx);
        }
        catch (IllegalAccessException ex) {
            throw new IllegalStateException(ex);
        }
        catch (InstantiationException ex) {
            throw new IllegalStateException(ex);
        }
        return proxy2;
    }
}

