/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.titanium.client.screen.addon.color;

import com.hrznstudio.titanium.api.client.AssetTypes;
import com.hrznstudio.titanium.client.screen.addon.BasicScreenAddon;
import com.hrznstudio.titanium.client.screen.asset.IAssetProvider;
import com.hrznstudio.titanium.util.AssetUtil;
import java.awt.Color;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;

public class ShadePickerAddon
extends BasicScreenAddon {
    private static final int S_TILES = 10;
    private static final int V_TILES = 10;
    private final Supplier<Float> hueSupplier;
    private final Consumer<Float> brightnessConsumer;
    private final Consumer<Float> saturationConsumer;
    private float brightness;
    private float saturation;

    public ShadePickerAddon(int posX, int posY, float brightness, float saturation, Supplier<Float> hueSupplier, Consumer<Float> brightnessConsumer, Consumer<Float> saturationConsumer) {
        super(posX, posY);
        this.hueSupplier = hueSupplier;
        this.brightness = brightness;
        this.saturation = saturation;
        this.brightnessConsumer = brightnessConsumer;
        this.saturationConsumer = saturationConsumer;
    }

    @Override
    public int getXSize() {
        return 100;
    }

    @Override
    public int getYSize() {
        return 80;
    }

    @Override
    public void drawBackgroundLayer(GuiGraphics stack, Screen screen, IAssetProvider provider, int guiX, int guiY, int mouseX, int mouseY, float partialTicks) {
        this.drawTiledGradient(stack, this.getPosX() + guiX, this.getPosY() + guiY, this.getXSize(), this.getYSize());
        AssetUtil.drawAsset(stack, screen, provider.getAsset(AssetTypes.SHADE_PICKER), guiX + (int)((float)this.getPosX() + this.saturation * (float)this.getXSize()) - 4, (int)((float)(guiY + this.getPosY()) + (1.0f - this.brightness) * (float)this.getYSize()) - 4);
    }

    @Override
    public void drawForegroundLayer(GuiGraphics stack, Screen screen, IAssetProvider provider, int guiX, int guiY, int mouseX, int mouseY, float partialTicks) {
    }

    private void drawTiledGradient(GuiGraphics guiGraphics, int x, int y, int width, int height) {
        int tileWidth = Math.round((float)width / 10.0f);
        int tileHeight = Math.round((float)height / 10.0f);
        for (int i = 0; i < 10; ++i) {
            float minV = (float)i / 10.0f;
            float maxV = (float)(i + 1) / 10.0f;
            for (int j = 0; j < 10; ++j) {
                float minS = (float)j / 10.0f;
                float maxS = (float)(j + 1) / 10.0f;
                Color tl = Color.getHSBColor(this.hueSupplier.get().floatValue(), minS, maxV);
                Color tr = Color.getHSBColor(this.hueSupplier.get().floatValue(), maxS, maxV);
                Color bl = Color.getHSBColor(this.hueSupplier.get().floatValue(), minS, minV);
                Color br = Color.getHSBColor(this.hueSupplier.get().floatValue(), maxS, minV);
                this.drawGradient(guiGraphics, x + j * tileWidth, y + (10 - i - 1) * tileHeight, tileWidth, tileHeight, tl, tr, bl, br);
            }
        }
    }

    private void drawGradient(GuiGraphics guiGraphics, int x, int y, int width, int height, Color tl, Color tr, Color bl, Color br) {
    }

    @Override
    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        this.saturation = ((float)mouseX - (float)this.getPosX()) / (float)this.getXSize();
        this.brightness = 1.0f - ((float)mouseY - (float)this.getPosY()) / (float)this.getYSize();
        this.saturationConsumer.accept(Float.valueOf(this.saturation));
        this.brightnessConsumer.accept(Float.valueOf(this.brightness));
        return super.m_7979_(mouseX, mouseY, button, dragX, dragY);
    }

    @Override
    public boolean m_6375_(double mouseX, double mouseY, int button) {
        this.saturation = (float)((mouseX - (double)this.getPosX()) / (double)this.getXSize());
        this.brightness = 1.0f - (float)((mouseY - (double)this.getPosY()) / (double)this.getYSize());
        this.saturationConsumer.accept(Float.valueOf(this.saturation));
        this.brightnessConsumer.accept(Float.valueOf(this.brightness));
        return true;
    }

    public void setBrightness(float brightness) {
        this.brightness = brightness;
    }

    public void setSaturation(float saturation) {
        this.saturation = saturation;
    }
}

