/*
 * Decompiled with CFR 0.152.
 */
package corgitaco.corgilib.serialization.codec;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Lifecycle;
import com.mojang.serialization.ListBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Supplier;

public record CollectionCodec<TYPE, COLLECTION extends Collection<TYPE>>(Codec<TYPE> element, Supplier<COLLECTION> collectionConstruction) implements Codec<COLLECTION>
{
    public <T> DataResult<T> encode(COLLECTION input, DynamicOps<T> ops, T prefix) {
        ListBuilder builder = ops.listBuilder();
        for (Object type : input) {
            builder.add(this.element.encodeStart(ops, type));
        }
        return builder.build(prefix);
    }

    public <T> DataResult<Pair<COLLECTION, T>> decode(DynamicOps<T> ops, T input) {
        return ops.getList(input).setLifecycle(Lifecycle.stable()).flatMap(consumer -> {
            Collection result = (Collection)this.collectionConstruction.get();
            ArrayList errors = new ArrayList();
            consumer.accept(t -> {
                DataResult decoded = this.element.decode(ops, t);
                decoded.error().ifPresent(e -> errors.add(t));
                result.add(((Pair)decoded.get().orThrow()).getFirst());
            });
            return DataResult.success((Object)Pair.of((Object)result, (Object)ops.createList(errors.stream())));
        });
    }
}

