/*
 * Decompiled with CFR 0.152.
 */
package corgitaco.corgilib.reg.registries;

import com.google.common.collect.MapMaker;
import java.util.concurrent.ConcurrentMap;
import net.minecraft.resources.ResourceLocation;

public final class RegistryFeatureType<X> {
    private static final ConcurrentMap<ResourceLocation, RegistryFeatureType<?>> VALUES = new MapMaker().weakValues().makeMap();
    public static final RegistryFeatureType<Void> SYNCED = RegistryFeatureType.getNoArgs(new ResourceLocation("synced"));
    public static final RegistryFeatureType<Void> SAVED_TO_DISK = RegistryFeatureType.getNoArgs(new ResourceLocation("saved_to_disk"));
    public static final RegistryFeatureType<ResourceLocation> DEFAULTED = RegistryFeatureType.get(new ResourceLocation("defaulted"), ResourceLocation.class);
    public static final RegistryFeatureType<Void> SUPPORTS_OVERRIDES = RegistryFeatureType.getNoArgs(new ResourceLocation("forge", "supports_overrides"));
    private final ResourceLocation id;
    private final Class<X> argumentType;

    private RegistryFeatureType(ResourceLocation id, Class<X> argumentType) {
        this.id = id;
        this.argumentType = argumentType;
    }

    public static <X> RegistryFeatureType<X> get(ResourceLocation id, Class<X> argumentType) {
        return VALUES.computeIfAbsent(id, resourceLocation -> new RegistryFeatureType((ResourceLocation)resourceLocation, argumentType));
    }

    public static RegistryFeatureType<Void> getNoArgs(ResourceLocation id) {
        return RegistryFeatureType.get(id, Void.class);
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public Class<X> getArgumentType() {
        return this.argumentType;
    }
}

