/*
 * Decompiled with CFR 0.152.
 */
package corgitaco.corgilib.entity.condition;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import corgitaco.corgilib.entity.condition.Condition;
import corgitaco.corgilib.entity.condition.ConditionContext;
import it.unimi.dsi.fastutil.ints.IntArraySet;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.ArrayList;
import java.util.Collection;

public class EveryAmountOfDaysCondition
implements Condition {
    public static final Codec<EveryAmountOfDaysCondition> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.INT.listOf().fieldOf("amount_of_days").forGetter(everyAmountOfDaysCondition -> new ArrayList(everyAmountOfDaysCondition.amountOfDays)), (App)Codec.LONG.optionalFieldOf("day_length", (Object)24000L).forGetter(everyAmountOfDaysCondition -> everyAmountOfDaysCondition.dayLength), (App)Codec.INT.optionalFieldOf("day_offset", (Object)0).forGetter(everyAmountOfDaysCondition -> everyAmountOfDaysCondition.offset)).apply((Applicative)builder, EveryAmountOfDaysCondition::new));
    private final IntSet amountOfDays = new IntArraySet();
    private final int offset;
    private final long dayLength;

    public EveryAmountOfDaysCondition(Collection<Integer> amountOfDays, long dayLength, int offset) {
        this.offset = offset;
        this.dayLength = dayLength;
        if (amountOfDays.isEmpty()) {
            throw new IllegalArgumentException("No amount of day were specified.");
        }
        this.amountOfDays.addAll(amountOfDays);
    }

    @Override
    public boolean passes(ConditionContext conditionContext) {
        IntIterator intIterator = this.amountOfDays.iterator();
        while (intIterator.hasNext()) {
            int amountOfDays = (Integer)intIterator.next();
            long worldDay = conditionContext.world().m_46468_() / this.dayLength + (long)this.offset;
            if (worldDay / (long)amountOfDays != 0L) continue;
            return true;
        }
        return false;
    }

    @Override
    public Codec<? extends Condition> codec() {
        return CODEC;
    }
}

