/*
 * Decompiled with CFR 0.152.
 */
package org.antarcticgardens.newage.content.heat.heatpipe;

import com.simibubi.create.api.boiler.BoilerHeater;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.antarcticgardens.newage.NewAgeBlockEntityTypes;
import org.antarcticgardens.newage.config.NewAgeConfig;
import org.antarcticgardens.newage.content.heat.HeatBlockEntity;
import org.antarcticgardens.newage.content.heat.heatpipe.HeatPipeBlockEntity;
import org.jetbrains.annotations.Nullable;

public class HeatPipeBlock
extends Block
implements EntityBlock,
IWrenchable {
    public static BooleanProperty UP = BlockStateProperties.f_61366_;
    public static BooleanProperty DOWN = BlockStateProperties.f_61367_;
    public static BooleanProperty NORTH = BlockStateProperties.f_61368_;
    public static BooleanProperty EAST = BlockStateProperties.f_61369_;
    public static BooleanProperty SOUTH = BlockStateProperties.f_61370_;
    public static BooleanProperty WEST = BlockStateProperties.f_61371_;
    public static int massPipe = 0;

    public HeatPipeBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{UP, DOWN, NORTH, EAST, SOUTH, WEST});
    }

    private static BlockState checkHeatBlock(BlockState state, LevelAccessor world, BlockPos pos, Direction dir, BooleanProperty property) {
        HeatBlockEntity hbe;
        BlockEntity blockEntity = world.m_7702_(pos.m_121945_(dir));
        return (BlockState)state.m_61124_((Property)property, (Comparable)Boolean.valueOf(blockEntity instanceof HeatBlockEntity && (hbe = (HeatBlockEntity)blockEntity).canConnect(dir)));
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState state = this.m_49966_();
        Level world = context.m_43725_();
        BlockPos pos = context.m_8083_();
        return HeatPipeBlock.updateState(state, (LevelAccessor)world, pos);
    }

    public static BlockState updateState(BlockState state, LevelAccessor world, BlockPos pos) {
        state = HeatPipeBlock.checkHeatBlock(state, world, pos, Direction.DOWN, DOWN);
        state = HeatPipeBlock.checkHeatBlock(state, world, pos, Direction.UP, UP);
        state = HeatPipeBlock.checkHeatBlock(state, world, pos, Direction.NORTH, NORTH);
        state = HeatPipeBlock.checkHeatBlock(state, world, pos, Direction.EAST, EAST);
        state = HeatPipeBlock.checkHeatBlock(state, world, pos, Direction.SOUTH, SOUTH);
        state = HeatPipeBlock.checkHeatBlock(state, world, pos, Direction.WEST, WEST);
        return state;
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        return HeatPipeBlock.updateState(state, world, pos);
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block neighborBlock, BlockPos neighborPos, boolean movedByPiston) {
        super.m_6861_(state, level, pos, neighborBlock, neighborPos, movedByPiston);
        level.m_186460_(pos, (Block)this, 1);
    }

    public void m_6807_(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean movedByPiston) {
        super.m_6807_(state, level, pos, oldState, movedByPiston);
        level.m_186460_(pos, (Block)this, 1);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        VoxelShape shape = Shapes.m_83048_((double)0.25, (double)0.25, (double)0.25, (double)0.75, (double)0.75, (double)0.75);
        if (((Boolean)state.m_61143_((Property)UP)).booleanValue()) {
            shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.25, (double)0.75, (double)0.25, (double)0.75, (double)1.0, (double)0.75), (BooleanOp)BooleanOp.f_82695_);
        }
        if (((Boolean)state.m_61143_((Property)DOWN)).booleanValue()) {
            shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.25, (double)0.0, (double)0.25, (double)0.75, (double)0.25, (double)0.75), (BooleanOp)BooleanOp.f_82695_);
        }
        if (((Boolean)state.m_61143_((Property)NORTH)).booleanValue()) {
            shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.25, (double)0.25, (double)0.0, (double)0.75, (double)0.75, (double)0.25), (BooleanOp)BooleanOp.f_82695_);
        }
        if (((Boolean)state.m_61143_((Property)EAST)).booleanValue()) {
            shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.75, (double)0.25, (double)0.25, (double)1.0, (double)0.75, (double)0.75), (BooleanOp)BooleanOp.f_82695_);
        }
        if (((Boolean)state.m_61143_((Property)SOUTH)).booleanValue()) {
            shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.25, (double)0.25, (double)0.75, (double)0.75, (double)0.75, (double)1.0), (BooleanOp)BooleanOp.f_82695_);
        }
        if (((Boolean)state.m_61143_((Property)WEST)).booleanValue()) {
            shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0, (double)0.25, (double)0.25, (double)0.25, (double)0.75, (double)0.75), (BooleanOp)BooleanOp.f_82695_);
        }
        return shape;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return NewAgeBlockEntityTypes.HEAT_PIPE.create(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        int on = massPipe++;
        if (massPipe >= 20) {
            massPipe = 0;
        }
        return (world, blockPos, blockState, self) -> {
            if ((world.m_46467_() + (long)on) % 20L != 0L || !(self instanceof HeatPipeBlockEntity)) {
                return;
            }
            HeatPipeBlockEntity selfC = (HeatPipeBlockEntity)self;
            BlockPos heatPos = blockPos.m_7495_();
            float heat = BoilerHeater.findHeat((Level)level, (BlockPos)blockPos, (BlockState)level.m_8055_(heatPos));
            selfC.generating = 0.0f;
            double loss = (Double)NewAgeConfig.getCommon().passivePipeHeatLoss.get();
            selfC.heat = (float)Math.max(0.0, (double)selfC.heat - loss);
            if (heat >= 0.0f) {
                selfC.generating = (1.0f + heat * 3.0f) * 6.0f;
                selfC.generating = (float)Math.max(Math.min((double)selfC.generating, (2.0 + Math.pow(2.0, heat)) * 300.0 - (double)selfC.heat), 0.0);
                selfC.heat += selfC.generating;
            }
            selfC.generating -= (float)loss;
            HeatBlockEntity.transferAround(selfC);
            HeatBlockEntity.handleOverheat(selfC);
            HeatBlockEntity.trySync(selfC);
        };
    }
}

