/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import io.github.mortuusars.exposure.ExposureClient;
import io.github.mortuusars.exposure.entity.PhotographFrameEntity;
import io.github.mortuusars.exposure.render.PhotographRenderer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.NotNull;

public class PhotographFrameEntityRenderer<T extends PhotographFrameEntity>
extends EntityRenderer<T> {
    private final BlockRenderDispatcher blockRenderer;

    public PhotographFrameEntityRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.blockRenderer = context.m_234597_();
    }

    @NotNull
    public ResourceLocation getTextureLocation(@NotNull T pEntity) {
        return InventoryMenu.f_39692_;
    }

    public boolean shouldRender(T livingEntity, Frustum camera, double camX, double camY, double camZ) {
        return super.m_5523_(livingEntity, camera, camX, camY, camZ);
    }

    public void render(@NotNull T entity, float entityYaw, float partialTick, @NotNull PoseStack poseStack, @NotNull MultiBufferSource bufferSource, int packedLight) {
        ItemStack item;
        EntityHitResult entityHitResult;
        HitResult hitResult = Minecraft.m_91087_().f_91077_;
        if (hitResult instanceof EntityHitResult && (entityHitResult = (EntityHitResult)hitResult).m_82443_() == entity) {
            Minecraft.m_91087_().f_91076_ = entity;
        }
        Direction direction = entity.m_6350_();
        int size = ((PhotographFrameEntity)((Object)entity)).getSize();
        boolean isStripped = ((PhotographFrameEntity)((Object)entity)).isStripped();
        poseStack.m_85836_();
        poseStack.m_252880_((float)direction.m_122429_() * 0.3f, (float)direction.m_122430_() * 0.3f, (float)direction.m_122431_() * 0.3f);
        super.m_7392_(entity, entityYaw, partialTick, poseStack, bufferSource, packedLight);
        poseStack.m_85849_();
        poseStack.m_85836_();
        double hangOffset = 0.46875;
        poseStack.m_85837_((double)direction.m_122429_() * hangOffset, (double)direction.m_122430_() * hangOffset, (double)direction.m_122431_() * hangOffset);
        poseStack.m_252781_(Axis.f_252529_.m_252977_(entity.m_146909_()));
        poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f - entity.m_146908_()));
        if (!entity.m_20145_()) {
            this.renderFrame(entity, poseStack, bufferSource, packedLight, size, isStripped);
        }
        if (!(item = ((PhotographFrameEntity)((Object)entity)).getItem()).m_41619_()) {
            this.renderPhotograph(entity, poseStack, bufferSource, packedLight, item, size, isStripped);
        }
        poseStack.m_85849_();
    }

    private void renderFrame(@NotNull T entity, @NotNull PoseStack poseStack, @NotNull MultiBufferSource bufferSource, int packedLight, int size, boolean isStripped) {
        poseStack.m_85836_();
        poseStack.m_252880_(-0.5f, -0.5f, -0.5f);
        ModelResourceLocation modelLocation = this.getModelLocation(entity, size, isStripped);
        BakedModel model = this.blockRenderer.m_110907_().m_110881_().m_119422_(modelLocation);
        this.blockRenderer.m_110937_().m_111067_(poseStack.m_85850_(), bufferSource.m_6299_(Sheets.m_110789_()), null, model, 1.0f, 1.0f, 1.0f, packedLight, OverlayTexture.f_118083_);
        poseStack.m_85849_();
    }

    public ModelResourceLocation getModelLocation(T entity, int size, boolean isStripped) {
        if (size == 0) {
            return isStripped ? ExposureClient.Models.PHOTOGRAPH_FRAME_SMALL_STRIPPED : ExposureClient.Models.PHOTOGRAPH_FRAME_SMALL;
        }
        if (size == 1) {
            return isStripped ? ExposureClient.Models.PHOTOGRAPH_FRAME_MEDIUM_STRIPPED : ExposureClient.Models.PHOTOGRAPH_FRAME_MEDIUM;
        }
        return isStripped ? ExposureClient.Models.PHOTOGRAPH_FRAME_LARGE_STRIPPED : ExposureClient.Models.PHOTOGRAPH_FRAME_LARGE;
    }

    private void renderPhotograph(@NotNull T entity, @NotNull PoseStack poseStack, @NotNull MultiBufferSource bufferSource, int packedLight, ItemStack item, int size, boolean isStripped) {
        poseStack.m_85836_();
        boolean frameInvisible = entity.m_20145_();
        float frameBorderOffset = frameInvisible || isStripped ? 0.0f : 0.125f;
        float offsetFromCenter = frameInvisible ? 0.497f : 0.48f;
        float desiredSize = (float)(size + 1) - frameBorderOffset * 2.0f;
        float scale = desiredSize / (float)ExposureClient.getExposureRenderer().getSize();
        poseStack.m_252781_(Axis.f_252403_.m_252977_((float)((PhotographFrameEntity)((Object)entity)).getItemRotation() * 360.0f / 4.0f));
        poseStack.m_252781_(Axis.f_252403_.m_252977_(180.0f));
        poseStack.m_85837_(-0.5 * (double)(size + 1) + (double)frameBorderOffset, -0.5 * (double)(size + 1) + (double)frameBorderOffset, (double)offsetFromCenter);
        poseStack.m_85841_(scale, scale, 1.0f);
        boolean isGlowing = ((PhotographFrameEntity)((Object)entity)).isGlowing();
        if (isGlowing) {
            packedLight = 0xF000F0;
        }
        int brightness = isGlowing ? 255 : this.getPhotographBrightness(entity);
        PhotographRenderer.render(item, false, false, poseStack, bufferSource, packedLight, brightness, brightness, brightness, 255);
        poseStack.m_85849_();
    }

    public int getPhotographBrightness(T entity) {
        if (entity.m_6350_() == Direction.UP) {
            return 255;
        }
        int lightLevel = entity.m_9236_().m_45517_(LightLayer.BLOCK, entity.m_20183_());
        float shadeFactor = entity.m_9236_().m_7717_(entity.m_6350_(), true);
        shadeFactor += (1.0f - shadeFactor) * 0.2f;
        int shadedBrightness = (int)(255.0f * shadeFactor);
        int missingLight = 255 - shadedBrightness;
        int lightUp = (int)((float)missingLight * ((float)lightLevel / 15.0f * 0.5f));
        return Math.min(255, shadedBrightness + lightUp);
    }

    protected boolean shouldShowName(T entity) {
        if (Minecraft.m_91404_() && !((PhotographFrameEntity)((Object)entity)).getItem().m_41619_() && ((PhotographFrameEntity)((Object)entity)).getItem().m_41788_() && Minecraft.m_91087_().f_91076_ == entity) {
            double distSqr = Minecraft.m_91087_().f_91076_.m_20280_(entity);
            float showRangeSqr = entity.m_20163_() ? 32.0f : 64.0f;
            return distSqr < (double)(showRangeSqr * showRangeSqr);
        }
        return false;
    }

    protected void renderNameTag(T entity, Component displayName, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        super.m_7649_(entity, ((PhotographFrameEntity)((Object)entity)).getItem().m_41786_(), poseStack, buffer, packedLight);
    }
}

