/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.command.exposure;

import com.google.common.base.Preconditions;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import io.github.mortuusars.exposure.Exposure;
import io.github.mortuusars.exposure.camera.capture.CapturedFramesHistory;
import io.github.mortuusars.exposure.item.ChromaticSheetItem;
import io.github.mortuusars.exposure.network.Packets;
import io.github.mortuusars.exposure.network.packet.client.ClearRenderingCacheS2CP;
import io.github.mortuusars.exposure.network.packet.client.OnFrameAddedS2CP;
import java.util.List;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class DebugCommand {
    public static LiteralArgumentBuilder<CommandSourceStack> get() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"debug").then(Commands.m_82127_((String)"clearRenderingCache").executes(DebugCommand::clearRenderingCache))).then(Commands.m_82127_((String)"chromaticFromLastThreeExposures").executes(DebugCommand::chromaticFromLastThreeExposures));
    }

    private static int clearRenderingCache(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        CommandSourceStack stack = (CommandSourceStack)context.getSource();
        ServerPlayer player = stack.m_81375_();
        Packets.sendToClient(new ClearRenderingCacheS2CP(), player);
        return 0;
    }

    private static int chromaticFromLastThreeExposures(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        CommandSourceStack stack = (CommandSourceStack)context.getSource();
        ServerPlayer player = stack.m_81375_();
        List<CompoundTag> frames = CapturedFramesHistory.get();
        if (frames.size() < 3) {
            stack.m_81352_((Component)Component.m_237113_((String)"Not enough frames were captured in this session. 3 is required."));
            return 1;
        }
        try {
            ChromaticSheetItem item = Exposure.Items.CHROMATIC_SHEET.get();
            ItemStack itemStack = new ItemStack((ItemLike)item);
            item.addExposure(itemStack, frames.get(2));
            item.addExposure(itemStack, frames.get(1));
            item.addExposure(itemStack, frames.get(0));
            ItemStack photographStack = item.finalize(player.m_9236_(), itemStack, player.m_6302_(), player);
            CompoundTag frame = photographStack.m_41783_();
            Preconditions.checkState((frame != null ? 1 : 0) != 0);
            Packets.sendToClient(new OnFrameAddedS2CP(frame), player);
            stack.m_288197_(() -> Component.m_237113_((String)("Created chromatic exposure: " + frame.m_128461_("Id"))), true);
        }
        catch (Exception e) {
            stack.m_81352_((Component)Component.m_237113_((String)("Failed to create chromatic exposure: " + String.valueOf(e))));
            return 1;
        }
        return 0;
    }
}

