/*
 * Decompiled with CFR 0.152.
 */
package com.github.almostreliable.energymeter.component;

import com.github.almostreliable.energymeter.meter.MeterEntity;
import com.github.almostreliable.energymeter.util.TypeEnums;
import java.util.Arrays;
import java.util.List;
import net.minecraft.core.Direction;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;

public record SidedEnergyStorage(MeterEntity parent, Direction side) implements IEnergyStorage
{
    public static List<LazyOptional<SidedEnergyStorage>> create(MeterEntity parent) {
        return Arrays.stream(Direction.values()).map(direction -> LazyOptional.of(() -> new SidedEnergyStorage(parent, (Direction)direction))).toList();
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        if (!this.canReceive()) {
            return 0;
        }
        return this.parent.receiveEnergy(maxReceive, simulate);
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        return 0;
    }

    public int getEnergyStored() {
        return 0;
    }

    public int getMaxEnergyStored() {
        return 0;
    }

    public boolean canExtract() {
        return this.parent.getSideConfig().get(this.side) == TypeEnums.IO_SETTING.OUT && this.parent.getSideConfig().hasInput();
    }

    public boolean canReceive() {
        if (this.parent.getMode() == TypeEnums.MODE.CONSUMER) {
            return this.parent.getSideConfig().get(this.side) == TypeEnums.IO_SETTING.IN;
        }
        return this.parent.getSideConfig().get(this.side) == TypeEnums.IO_SETTING.IN && this.parent.getSideConfig().hasOutput();
    }
}

