/*
 * Decompiled with CFR 0.152.
 */
package com.github.almostreliable.energymeter.client.gui;

import com.github.almostreliable.energymeter.client.gui.GenericButton;
import com.github.almostreliable.energymeter.client.gui.MeterScreen;
import com.github.almostreliable.energymeter.component.SideConfiguration;
import com.github.almostreliable.energymeter.network.PacketHandler;
import com.github.almostreliable.energymeter.network.packets.IOUpdatePacket;
import com.github.almostreliable.energymeter.util.GuiUtils;
import com.github.almostreliable.energymeter.util.TextUtils;
import com.github.almostreliable.energymeter.util.TypeEnums;
import java.util.Arrays;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Tuple;

final class IOButton
extends GenericButton {
    private static final String TEXTURE = "io";
    private static final int POS_X = 141;
    private static final int POS_Y = 5;
    private static final int TEXTURE_WIDTH = 34;
    private static final int TEXTURE_HEIGHT = 34;
    private static final int BUTTON_SIZE = 17;
    private static final int ZONE_SIZE = 18;
    private static final int OVERLAY_SIZE = 17;
    private final TypeEnums.BLOCK_SIDE side;
    private GuiUtils.TooltipBuilder tooltip;
    private TypeEnums.IO_SETTING setting;

    private IOButton(MeterScreen screen, TypeEnums.BLOCK_SIDE side) {
        super(screen, 141 + (Integer)IOButton.getButtonPos(side).m_14418_(), 5 + (Integer)IOButton.getButtonPos(side).m_14419_(), 17, 17);
        this.side = side;
        this.setting = this.container.getEntity().getSideConfig().get(side);
        this.tooltip = this.setupTooltip();
    }

    static List<IOButton> create(MeterScreen screen, TypeEnums.BLOCK_SIDE ... sides) {
        return Arrays.stream(sides).filter(side -> side != TypeEnums.BLOCK_SIDE.FRONT).map(side -> new IOButton(screen, (TypeEnums.BLOCK_SIDE)((Object)side))).toList();
    }

    private static Tuple<Integer, Integer> getButtonPos(TypeEnums.BLOCK_SIDE side) {
        return switch (side) {
            default -> throw new IncompatibleClassChangeError();
            case TypeEnums.BLOCK_SIDE.TOP -> new Tuple((Object)18, (Object)0);
            case TypeEnums.BLOCK_SIDE.LEFT -> new Tuple((Object)0, (Object)18);
            case TypeEnums.BLOCK_SIDE.RIGHT -> new Tuple((Object)36, (Object)18);
            case TypeEnums.BLOCK_SIDE.BOTTOM -> new Tuple((Object)18, (Object)36);
            case TypeEnums.BLOCK_SIDE.BACK -> new Tuple((Object)36, (Object)36);
            case TypeEnums.BLOCK_SIDE.FRONT -> new Tuple((Object)0, (Object)0);
        };
    }

    public void m_5716_(double mX, double mY) {
        if (this.f_93622_) {
            this.changeMode(Screen.m_96638_());
        }
        super.m_5716_(mX, mY);
    }

    @Override
    public void m_87963_(GuiGraphics guiGraphics, int mX, int mY, float partial) {
        super.m_87963_(guiGraphics, mX, mY, partial);
        this.renderIOOverlay(guiGraphics);
    }

    @Override
    protected void clickHandler() {
        PacketHandler.CHANNEL.sendToServer((Object)new IOUpdatePacket(this.side, this.setting));
        this.tooltip = this.setupTooltip();
    }

    @Override
    protected String getTexture() {
        return TEXTURE;
    }

    @Override
    protected int getTextureWidth() {
        return 34;
    }

    @Override
    protected int getTextureHeight() {
        return 34;
    }

    @Override
    protected GuiUtils.TooltipBuilder getTooltipBuilder() {
        return this.tooltip;
    }

    private GuiUtils.TooltipBuilder setupTooltip() {
        return GuiUtils.TooltipBuilder.builder().addHeader("side_config").addBlankLine().addComponent((Component)TextUtils.translate(TypeEnums.TRANSLATE_TYPE.TOOLTIP, "io_side", ChatFormatting.GREEN).m_7220_((Component)TextUtils.colorize(": ", ChatFormatting.GREEN)).m_7220_((Component)TextUtils.translate(TypeEnums.TRANSLATE_TYPE.BLOCK_SIDE, this.side.toString().toLowerCase(), ChatFormatting.WHITE))).addComponent((Component)TextUtils.translate(TypeEnums.TRANSLATE_TYPE.TOOLTIP, "io_mode", ChatFormatting.GREEN).m_7220_((Component)TextUtils.colorize(": ", ChatFormatting.GREEN)).m_7220_((Component)TextUtils.translate(TypeEnums.TRANSLATE_TYPE.IO_SETTING, this.setting.toString().toLowerCase(), ChatFormatting.WHITE))).addBlankLine().addClickAction("action_1").addShiftClickAction("action_2");
    }

    private void renderIOOverlay(GuiGraphics guiGraphics) {
        int textureOffset = (this.setting.ordinal() - 1) * 17;
        if (textureOffset >= 0) {
            guiGraphics.m_280163_(TextUtils.getRL("textures/gui/buttons/" + this.getTexture() + ".png"), this.m_252754_(), this.m_252907_(), 17.0f, (float)textureOffset, 17, 17, 34, 34);
        }
    }

    private void changeMode(boolean reset) {
        if (reset) {
            this.setting = TypeEnums.IO_SETTING.OFF;
            return;
        }
        SideConfiguration sideConfig = this.container.getEntity().getSideConfig();
        this.setting = switch (this.setting) {
            default -> throw new IncompatibleClassChangeError();
            case TypeEnums.IO_SETTING.OFF -> {
                if (sideConfig.hasInput()) {
                    yield TypeEnums.IO_SETTING.OUT;
                }
                yield TypeEnums.IO_SETTING.IN;
            }
            case TypeEnums.IO_SETTING.IN -> {
                if (sideConfig.hasMaxOutputs()) {
                    yield TypeEnums.IO_SETTING.OFF;
                }
                yield TypeEnums.IO_SETTING.OUT;
            }
            case TypeEnums.IO_SETTING.OUT -> TypeEnums.IO_SETTING.OFF;
        };
    }
}

