/*
 * Decompiled with CFR 0.152.
 */
package dev.hail.create_fantasizing.item;

import com.simibubi.create.AllItems;
import com.simibubi.create.content.kinetics.saw.TreeCutter;
import com.simibubi.create.foundation.item.render.CustomRenderedItemModelRenderer;
import com.simibubi.create.foundation.item.render.SimpleCustomRenderer;
import com.simibubi.create.foundation.utility.AbstractBlockBreakQueue;
import dev.hail.create_fantasizing.item.TreeCutterItemRenderer;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.ParametersAreNonnullByDefault;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class TreeCutterItem
extends AxeItem {
    protected BlockPos breakingPos;
    protected Level level;
    protected BlockPos worldPosition;
    public static final Tier STURDY = new Tier(){

        public int m_6609_() {
            return 2048;
        }

        public float m_6624_() {
            return 9.0f;
        }

        public float m_6631_() {
            return 9.0f;
        }

        public int m_6604_() {
            return 4;
        }

        public int m_6601_() {
            return 15;
        }

        public Ingredient m_6282_() {
            return Ingredient.m_43929_((ItemLike[])new ItemLike[]{AllItems.STURDY_SHEET});
        }
    };

    public TreeCutterItem(Item.Properties properties) {
        super(STURDY, 0.0f, -3.0f, properties);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept((IClientItemExtensions)SimpleCustomRenderer.create((Item)this, (CustomRenderedItemModelRenderer)new TreeCutterItemRenderer()));
    }

    public boolean m_6813_(ItemStack stack, Level level, BlockState state, BlockPos pos, LivingEntity miningEntity) {
        if (state.m_204336_(BlockTags.f_13106_) && !miningEntity.m_6047_()) {
            this.level = level;
            this.breakingPos = pos;
            this.worldPosition = pos;
            Optional dynamicTree = TreeCutter.findDynamicTree((Block)state.m_60734_(), (BlockPos)this.breakingPos);
            if (dynamicTree.isPresent()) {
                ((AbstractBlockBreakQueue)dynamicTree.get()).destroyBlocks(level, null, this::dropItemFromCutTree);
                return true;
            }
            TreeCutter.findTree((BlockGetter)level, (BlockPos)this.breakingPos, (BlockState)state).destroyBlocks(level, null, this::dropItemFromCutTree);
        }
        return super.m_6813_(stack, level, state, pos, miningEntity);
    }

    public void dropItemFromCutTree(BlockPos pos, ItemStack stack) {
        float distance = (float)Math.sqrt(pos.m_123331_((Vec3i)this.breakingPos));
        Vec3 dropPos = VecHelper.getCenterOf((Vec3i)pos);
        ItemEntity entity = new ItemEntity(this.level, dropPos.f_82479_, dropPos.f_82480_, dropPos.f_82481_, stack);
        entity.m_20256_(Vec3.m_82528_((Vec3i)this.breakingPos.m_121996_((Vec3i)this.worldPosition)).m_82490_((double)(distance / 20.0f)));
        this.level.m_7967_((Entity)entity);
    }
}

