/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.core.client.renderers;

import com.legacy.structure_gel.core.SGConfig;
import com.legacy.structure_gel.core.client.renderers.BuildingToolRenderer;
import com.legacy.structure_gel.core.client.renderers.IRenderBase;
import com.legacy.structure_gel.core.item.building_tool.BuildingToolItem;
import com.legacy.structure_gel.core.item.building_tool.BuildingToolModes;
import com.legacy.structure_gel.core.item.building_tool.CapturedBlocks;
import com.legacy.structure_gel.core.item.building_tool.ToolModeProperty;
import com.legacy.structure_gel.core.item.building_tool.modes.CloneTool;
import com.legacy.structure_gel.core.item.building_tool.modes.ExtendTool;
import com.legacy.structure_gel.core.item.building_tool.modes.FloodTool;
import com.legacy.structure_gel.core.item.building_tool.modes.LineTool;
import com.legacy.structure_gel.core.item.building_tool.modes.ReplaceTool;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.joml.Matrix4f;

public class BuildingToolRenderers {
    public static void init() {
    }

    static {
        BuildingToolRenderer.RENDERERS.put(BuildingToolModes.REPLACE, () -> new BuildingToolRenderer(){

            @Override
            protected void compileInfo(Minecraft mc, ItemStack stack, PoseStack poseStack, BufferBuilder buffBuilder, double camX, double camY, double camZ, BuildingToolRenderer.RenderInfo renderInfo) {
                renderInfo.renderPos = this.renderPos;
                if (this.hitPos != null) {
                    renderInfo.renderPos = this.hitPos;
                    int r = BuildingToolItem.getProperty(stack, ToolModeProperty.MEDIUM_RADIUS);
                    boolean fuzzy = BuildingToolItem.getProperty(stack, ToolModeProperty.FUZZY_TRUE).value();
                    Set<BlockPos> poses = ReplaceTool.getReplacePositions((Level)mc.f_91073_, this.hitPos, r, fuzzy).stream().map(p -> p.m_121996_((Vec3i)this.hitPos)).collect(Collectors.toSet());
                    IRenderBase.highlightBlocks(poseStack, (VertexConsumer)buffBuilder, renderInfo.renderPos, poses, 0.75f, 0.0f, 0.75f, 0.3f);
                    IRenderBase.makeLineBox(poseStack, (VertexConsumer)buffBuilder, BoundingBox.m_162375_((Vec3i)Vec3i.f_123288_, (Vec3i)Vec3i.f_123288_), 0.75f, 0.0f, 0.75f, 0.3f);
                }
            }
        });
        BuildingToolRenderer.RENDERERS.put(BuildingToolModes.FILL, () -> new BuildingToolRenderer.ForCorners(){

            @Override
            protected void compileInfo(Minecraft mc, ItemStack stack, PoseStack poseStack, BufferBuilder buffBuilder, double camX, double camY, double camZ, BuildingToolRenderer.RenderInfo renderInfo) {
                ToolModeProperty.Shape shape;
                if (this.pos != null && this.secondPos != null && (shape = BuildingToolItem.getProperty(stack, ToolModeProperty.FILL_SHAPE)) != ToolModeProperty.Shape.CUBE) {
                    HashSet<BlockPos> poses = new HashSet<BlockPos>();
                    BoundingBox bounds = BoundingBox.m_162375_((Vec3i)this.pos, (Vec3i)this.secondPos);
                    double dx = (double)(bounds.m_71056_() - 1) / 2.0;
                    double dy = (double)(bounds.m_71057_() - 1) / 2.0;
                    double dz = (double)(bounds.m_71058_() - 1) / 2.0;
                    int yInvert = bounds.m_162400_() - bounds.m_162396_();
                    BlockPos centerPos = bounds.m_162394_();
                    for (int x = bounds.m_162395_(); x <= bounds.m_162399_(); ++x) {
                        for (int z = bounds.m_162398_(); z <= bounds.m_162401_(); ++z) {
                            for (int y = bounds.m_162396_(); y <= bounds.m_162400_(); ++y) {
                                BlockPos pos = centerPos.m_7918_(-x, -y, -z);
                                if (!shape.isInside(Vec3.m_82528_((Vec3i)pos), dx, dy, dz)) continue;
                                BlockPos rPos = pos.m_7918_((int)dx, (int)dy, (int)dz);
                                poses.add(new BlockPos(rPos.m_123341_(), yInvert - rPos.m_123342_(), rPos.m_123343_()));
                            }
                        }
                    }
                    Vec3i shapeRenderPos = new Vec3i(bounds.m_162395_(), bounds.m_162396_(), bounds.m_162398_());
                    IRenderBase.highlightBlocks(poseStack, (VertexConsumer)buffBuilder, shapeRenderPos, poses, 0.75f, 0.0f, 0.75f, 0.3f);
                }
                super.compileInfo(mc, stack, poseStack, buffBuilder, camX, camY, camZ, renderInfo);
            }

            @Override
            protected float[] getOutlineRGB() {
                return new float[]{0.75f, 0.0f, 0.75f};
            }
        });
        BuildingToolRenderer.RENDERERS.put(BuildingToolModes.CLONE, () -> new BuildingToolRenderer.ForCorners(){
            @Nullable
            private CapturedBlocks capturedBlocksCache = null;
            @Nullable
            private VertexBuffer destBuffer = null;
            private final Tesselator destTesselator = new Tesselator();
            @Nullable
            private CompletableFuture<BuildingToolRenderer.RenderResult> destFutureRender = null;
            private BuildingToolRenderer.RenderInfo destLastRenderInfo = new BuildingToolRenderer.RenderInfo();

            @Override
            protected float[] getOutlineRGB() {
                return new float[]{0.0f, 0.85f, 0.0f};
            }

            @Override
            protected void updateData(Minecraft mc, ItemStack stack) {
                super.updateData(mc, stack);
                CapturedBlocks captured = BuildingToolItem.getCapturedBlocks(stack, (Level)mc.f_91073_, (Player)mc.f_91074_);
                if (captured != this.capturedBlocksCache) {
                    this.needsCompiled = true;
                    this.selectionChanged = true;
                }
                if (this.needsCompiled && (this.selectionChanged || this.itemChanged) && BuildingToolItem.getSelectedCorner(stack) == null) {
                    if (this.pos != null && this.secondPos != null && captured != null) {
                        RandomSource rand = mc.f_91073_.f_46441_;
                        ToolModeProperty.SGMirror mirror = BuildingToolItem.getProperty(stack, ToolModeProperty.MIRROR);
                        ToolModeProperty.SGRotation rotation = BuildingToolItem.getProperty(stack, ToolModeProperty.ROTATION);
                        CapturedBlocks capturedC = captured.withTransforms((mirror == ToolModeProperty.SGMirror.RANDOM ? ToolModeProperty.SGMirror.NONE : mirror).toVanilla(rand), (rotation == ToolModeProperty.SGRotation.RANDOM ? ToolModeProperty.SGRotation.R_0 : rotation).toVanilla(rand));
                        capturedC.compressForRender((Level)mc.f_91073_, this.pos);
                        this.capturedBlocksCache = capturedC;
                    } else {
                        this.capturedBlocksCache = null;
                    }
                }
            }

            @Override
            protected void compileInfo(Minecraft mc, ItemStack stack, PoseStack poseStack, BufferBuilder buffBuilder, double camX, double camY, double camZ, BuildingToolRenderer.RenderInfo renderInfo) {
                super.compileInfo(mc, stack, poseStack, buffBuilder, camX, camY, camZ, renderInfo);
            }

            protected void compileDest(Minecraft mc, ItemStack stack, PoseStack poseStack, BufferBuilder buffBuilder, double camX, double camY, double camZ, BuildingToolRenderer.RenderInfo renderInfo) {
                if (this.hitPos != null && this.pos != null && this.secondPos != null && this.capturedBlocksCache != null && BuildingToolItem.getSelectedCorner(stack) == null) {
                    BoundingBox destBB = CloneTool.getCloneDestBounds(this.capturedBlocksCache, BlockPos.f_121853_, Blocks.f_50016_.m_49966_(), Vec3.f_82478_, false);
                    BlockPos worldPos = new BlockPos(destBB.m_162395_(), destBB.m_162396_(), destBB.m_162398_());
                    Map<BlockPos, VoxelShape> shapes = this.capturedBlocksCache.getShapes((Level)mc.f_91073_, worldPos);
                    BoundingBox worldDestBB = CloneTool.getCloneDestBounds(this.capturedBlocksCache, this.hitPos, mc.f_91074_.m_9236_().m_8055_(this.hitPos), mc.f_91074_.m_20182_(), mc.f_91074_.m_6144_());
                    Vec3i cloneRenderPos = new Vec3i(worldDestBB.m_162395_() - (int)camX, worldDestBB.m_162396_() - (int)camY, worldDestBB.m_162398_() - (int)camZ);
                    IRenderBase.highlightVoxelShapes(poseStack, (VertexConsumer)buffBuilder, Vec3.f_82478_, cloneRenderPos, shapes, 0.6f, 0.0f, 0.9f, 0.7f);
                    IRenderBase.makeLineBox(poseStack, (VertexConsumer)buffBuilder, destBB, -0.01, 0.75f, 0.0f, 0.75f, 0.3f);
                }
            }

            @Override
            protected BuildingToolRenderer.RenderInfo compile(Minecraft mc, LocalPlayer player, ItemStack stack, double camX, double camY, double camZ) {
                BuildingToolRenderer.RenderInfo ret = super.compile(mc, player, stack, camX, camY, camZ);
                if (SGConfig.CLIENT.threadBuildingTool()) {
                    if (this.destFutureRender == null) {
                        this.destLastRenderInfo.isFinished = false;
                        this.destFutureRender = CompletableFuture.supplyAsync(() -> {
                            PoseStack poseStack = new PoseStack();
                            BufferBuilder buffBuilder = this.destTesselator.m_85915_();
                            buffBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
                            BuildingToolRenderer.RenderInfo renderInfo = new BuildingToolRenderer.RenderInfo();
                            this.compileDest(mc, stack, poseStack, buffBuilder, camX, camY, camZ, renderInfo);
                            return new BuildingToolRenderer.RenderResult(renderInfo, buffBuilder);
                        }, Util.m_183991_());
                    }
                    if (this.destFutureRender != null && this.destFutureRender.isDone()) {
                        try {
                            BuildingToolRenderer.RenderResult result = this.destFutureRender.get();
                            result.renderInfo().isFinished = true;
                            if (this.destBuffer != null) {
                                this.destBuffer.close();
                            }
                            this.destBuffer = new VertexBuffer(VertexBuffer.Usage.STATIC);
                            this.destBuffer.m_85921_();
                            this.destBuffer.m_231221_(result.buffBuilder().m_231175_());
                            this.destFutureRender = null;
                            VertexBuffer.m_85931_();
                            this.destLastRenderInfo = result.renderInfo();
                        }
                        catch (Throwable t) {
                            t.printStackTrace();
                        }
                    }
                } else {
                    PoseStack poseStack = new PoseStack();
                    BufferBuilder buffBuilder = Tesselator.m_85913_().m_85915_();
                    buffBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
                    BuildingToolRenderer.RenderInfo renderInfo = new BuildingToolRenderer.RenderInfo();
                    this.compileDest(mc, stack, poseStack, buffBuilder, camX, camY, camZ, renderInfo);
                    if (this.destBuffer != null) {
                        this.destBuffer.close();
                    }
                    this.destBuffer = new VertexBuffer(VertexBuffer.Usage.STATIC);
                    this.destBuffer.m_85921_();
                    this.destBuffer.m_231221_(buffBuilder.m_231175_());
                    VertexBuffer.m_85931_();
                    renderInfo.isFinished = true;
                    this.destLastRenderInfo = renderInfo;
                }
                ret.isFinished = ret.isFinished && this.destLastRenderInfo.isFinished;
                return ret;
            }

            @Override
            protected void render(Minecraft mc, LocalPlayer player, ItemStack stack, PoseStack poseStack, Matrix4f projectionMatrix, double camX, double camY, double camZ) {
                super.render(mc, player, stack, poseStack, projectionMatrix, camX, camY, camZ);
                if (this.destBuffer != null && this.hitPos != null && this.capturedBlocksCache != null) {
                    poseStack.m_85836_();
                    RenderSystem.setShader(GameRenderer::m_172811_);
                    RenderSystem.enableBlend();
                    RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
                    RenderSystem.enableDepthTest();
                    poseStack.m_85837_(camX, camY, camZ);
                    BoundingBox destBB = CloneTool.getCloneDestBounds(this.capturedBlocksCache, this.hitPos, player.m_9236_().m_8055_(this.hitPos), player.m_20182_(), player.m_6144_());
                    poseStack.m_85837_((double)destBB.m_162395_() - camX, (double)destBB.m_162396_() - camY, (double)destBB.m_162398_() - camZ);
                    this.destBuffer.m_85921_();
                    this.destBuffer.m_253207_(poseStack.m_85850_().m_252922_(), projectionMatrix, RenderSystem.getShader());
                    VertexBuffer.m_85931_();
                    RenderSystem.disableBlend();
                    RenderSystem.disableDepthTest();
                    poseStack.m_85849_();
                }
            }

            @Override
            protected void close() {
                super.close();
                if (this.destBuffer != null) {
                    this.destBuffer.close();
                }
                this.destBuffer = null;
            }
        });
        BuildingToolRenderer.RENDERERS.put(BuildingToolModes.FLOOD, () -> new BuildingToolRenderer(){

            @Override
            protected void compileInfo(Minecraft mc, ItemStack stack, PoseStack poseStack, BufferBuilder buffBuilder, double camX, double camY, double camZ, BuildingToolRenderer.RenderInfo renderInfo) {
                renderInfo.renderPos = this.renderPos;
                if (this.hitPos != null && this.hitFace != null && this.hitBlock) {
                    renderInfo.renderPos = this.hitPos;
                    IRenderBase.highlightBlockPos(poseStack, (VertexConsumer)buffBuilder, renderInfo.renderPos, 4.mapPosesTo(FloodTool.getFloodPositions((Level)mc.f_91073_, this.hitPos, this.hitFace, BuildingToolItem.getProperty(stack, ToolModeProperty.REPLACE_AIR_LIQUID), BuildingToolItem.getProperty(stack, ToolModeProperty.LARGE_RADIUS)), renderInfo.renderPos), 0.75f, 0.0f, 0.75f, 0.3f);
                }
            }
        });
        BuildingToolRenderer.RENDERERS.put(BuildingToolModes.EXTEND, () -> new BuildingToolRenderer(){
            private Set<BlockPos> extendPoses = new HashSet<BlockPos>();

            @Override
            protected void updateData(Minecraft mc, ItemStack stack) {
                super.updateData(mc, stack);
                if (!this.needsCompiled && this.hitPos != null && this.hitFace != null && this.extendPoses.size() != ExtendTool.getExtendPositions((Level)mc.f_91073_, this.hitPos, this.hitFace, BuildingToolItem.getProperty(stack, ToolModeProperty.REPLACE_AIR_LIQUID), BuildingToolItem.getProperty(stack, ToolModeProperty.LARGE_RADIUS)).size()) {
                    this.needsCompiled = true;
                }
            }

            @Override
            protected void compileInfo(Minecraft mc, ItemStack stack, PoseStack poseStack, BufferBuilder buffBuilder, double camX, double camY, double camZ, BuildingToolRenderer.RenderInfo renderInfo) {
                renderInfo.renderPos = this.renderPos;
                if (this.hitPos != null && this.hitFace != null && this.hitBlock) {
                    renderInfo.renderPos = this.hitPos;
                    this.extendPoses = ExtendTool.getExtendPositions((Level)mc.f_91073_, this.hitPos, this.hitFace, BuildingToolItem.getProperty(stack, ToolModeProperty.REPLACE_AIR_LIQUID), BuildingToolItem.getProperty(stack, ToolModeProperty.LARGE_RADIUS));
                    IRenderBase.highlightBlockPos(poseStack, (VertexConsumer)buffBuilder, renderInfo.renderPos, 5.mapPosesTo(this.extendPoses, renderInfo.renderPos), 0.75f, 0.0f, 0.75f, 0.3f);
                }
            }
        });
        BuildingToolRenderer.RENDERERS.put(BuildingToolModes.MOVE, () -> new BuildingToolRenderer.ForCorners(){

            @Override
            protected float[] getOutlineRGB() {
                return new float[]{0.75f, 0.0f, 0.75f};
            }
        });
        BuildingToolRenderer.RENDERERS.put(BuildingToolModes.LINE, () -> new BuildingToolRenderer.ForCorners(){

            @Override
            protected float[] getOutlineRGB() {
                return new float[]{0.75f, 0.0f, 0.75f};
            }

            @Override
            protected void compileInfo(Minecraft mc, ItemStack stack, PoseStack poseStack, BufferBuilder buffBuilder, double camX, double camY, double camZ, BuildingToolRenderer.RenderInfo renderInfo) {
                boolean hasPosB;
                super.compileInfo(mc, stack, poseStack, buffBuilder, camX, camY, camZ, renderInfo);
                boolean hasPosA = this.pos != null;
                boolean bl = hasPosB = this.secondPos != null;
                if (hasPosA && hasPosB) {
                    float[] rgb = this.getOutlineRGB();
                    float a = 0.3f;
                    IRenderBase.highlightBlockPos(poseStack, (VertexConsumer)buffBuilder, renderInfo.renderPos, 7.mapPosesTo(LineTool.getLinePositions(this.pos, this.secondPos), renderInfo.renderPos), rgb[0], rgb[1], rgb[2], a);
                }
            }
        });
        BuildingToolRenderer.RENDERERS.put(BuildingToolModes.SHAPE, () -> new BuildingToolRenderer(){

            @Override
            protected void compileInfo(Minecraft mc, ItemStack stack, PoseStack poseStack, BufferBuilder buffBuilder, double camX, double camY, double camZ, BuildingToolRenderer.RenderInfo renderInfo) {
                renderInfo.renderPos = this.renderPos;
                if (this.hitPos != null) {
                    int r = BuildingToolItem.getProperty(stack, ToolModeProperty.RADIUS);
                    BoundingBox destBB = BoundingBox.m_162375_((Vec3i)Vec3i.f_123288_.m_7918_(-r, -r, -r), (Vec3i)Vec3i.f_123288_.m_7918_(r, r, r));
                    renderInfo.renderPos = this.hitPos;
                    if (r <= 30) {
                        ToolModeProperty.Replace replace = BuildingToolItem.getProperty(stack, ToolModeProperty.REPLACE);
                        ToolModeProperty.Shape shape = BuildingToolItem.getProperty(stack, ToolModeProperty.SHAPE);
                        HashSet<BlockPos> poses = new HashSet<BlockPos>();
                        BlockState clickedState = mc.f_91073_.m_8055_(this.hitPos);
                        for (int x = -r; x <= r; ++x) {
                            for (int z = -r; z <= r; ++z) {
                                for (int y = -r; y <= r; ++y) {
                                    BlockPos pos = new BlockPos(x, y, z);
                                    if (!shape.isInside((Vec3i)pos.m_142393_(-1), r) || !replace.shouldReplace((Level)mc.f_91073_, clickedState, this.hitPos.m_121955_((Vec3i)pos))) continue;
                                    poses.add(pos);
                                }
                            }
                        }
                        IRenderBase.highlightBlocks(poseStack, (VertexConsumer)buffBuilder, renderInfo.renderPos, poses, 0.75f, 0.0f, 0.75f, 0.3f);
                    }
                    IRenderBase.makeLineBox(poseStack, (VertexConsumer)buffBuilder, destBB, 0.75f, 0.0f, 0.75f, 0.3f);
                }
            }
        });
    }
}

