/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.world.general_features.cave;

import com.google.common.collect.Lists;
import com.legacy.blue_skies.BlueSkies;
import com.legacy.blue_skies.world.general_features.cave.AbstractCaveFeature;
import com.legacy.structure_gel.api.structure.base.IModifyState;
import com.legacy.structure_gel.api.structure.processor.RemoveGelStructureProcessor;
import com.legacy.structure_gel.core.structure.GelTemplate;
import com.mojang.serialization.Codec;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.entity.SpawnerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.StructureMode;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockIgnoreProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;

public abstract class AbstractCaveSpawnerFeature
extends AbstractCaveFeature<NoneFeatureConfiguration> {
    protected final List<SpawnerTemplateData> templates;

    public AbstractCaveSpawnerFeature(Codec<NoneFeatureConfiguration> codec, SpawnerTemplateData ... templates) {
        super(codec);
        this.templates = Lists.newArrayList((Object[])templates);
    }

    @Override
    public boolean generate(WorldGenLevel world, ChunkGenerator chunkGen, RandomSource rand, BlockPos pos, NoneFeatureConfiguration config) {
        BlockPos placePos = pos;
        boolean flag = false;
        Rotation rotation = Rotation.m_221990_((RandomSource)rand);
        StructureTemplateManager manager = world.m_6018_().m_7654_().m_236738_();
        SpawnerTemplateData templateData = this.getRandomTemplate(rand);
        StructureTemplate template = manager.m_230359_(templateData.templateName);
        Vec3i size = template.m_163808_(rotation);
        placePos = template.m_74583_(placePos, Mirror.NONE, rotation);
        placePos = pos.m_7918_(-(pos.m_123341_() % 16), 0, -(pos.m_123343_() % 16));
        BlockPos centerPos = placePos.m_7918_(size.m_123341_() / 2, 0, size.m_123343_() / 2);
        for (int i = 0; i < 7; ++i) {
            BlockState lowerState = world.m_8055_(centerPos.m_6625_(i + 1));
            if (!world.m_46859_(centerPos.m_6625_(i)) || !lowerState.m_60815_()) continue;
            placePos = placePos.m_6625_(i + 2);
            flag = true;
            break;
        }
        if (flag) {
            BoundingBox bounds = BoundingBox.m_162375_((Vec3i)placePos, (Vec3i)placePos.m_121955_(size));
            StructurePlaceSettings placementSettings = new StructurePlaceSettings().m_74379_(rotation).m_230324_(rand).m_74381_(bounds).m_74385_(new BlockPos(size.m_123341_() / 2, 0, size.m_123343_() / 2)).m_74383_((StructureProcessor)BlockIgnoreProcessor.f_74048_).m_74383_((StructureProcessor)RemoveGelStructureProcessor.INSTANCE);
            GelTemplate.placeInWorld((StructureTemplate)template, (ServerLevelAccessor)world, (BlockPos)placePos, (BlockPos)placePos, (StructurePlaceSettings)placementSettings, (RandomSource)rand, (int)4, (IModifyState)templateData);
            StructurePlaceSettings tempSettings = new StructurePlaceSettings().m_74379_(rotation).m_74385_(new BlockPos(size.m_123341_() / 2, 0, size.m_123343_() / 2));
            ObjectArrayList infos = template.m_230335_(placePos, tempSettings, Blocks.f_50677_, false);
            for (StructureTemplate.StructureBlockInfo blockInfo : StructureTemplate.processBlockInfos((ServerLevelAccessor)world, (BlockPos)placePos, (BlockPos)placePos, (StructurePlaceSettings)tempSettings, (List)infos, (StructureTemplate)template)) {
                StructureMode mode;
                if (blockInfo.f_74677_() == null || (mode = StructureMode.valueOf((String)blockInfo.f_74677_().m_128461_("mode"))) != StructureMode.DATA) continue;
                String function = blockInfo.f_74677_().m_128461_("metadata");
                this.m_5974_((LevelWriter)world, blockInfo.f_74675_(), Blocks.f_50016_.m_49966_());
                templateData.handleDataMarker(function, blockInfo.f_74675_(), world, rand, bounds);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean isValidPos(WorldGenLevel world, ChunkGenerator chunkGen, RandomSource rand, BlockPos pos, NoneFeatureConfiguration config) {
        return world.m_46859_(pos);
    }

    @Override
    public boolean shouldGenerate(WorldGenLevel world, BlockPos pos) {
        return !world.m_6018_().m_215010_().m_220486_(pos);
    }

    protected SpawnerTemplateData getRandomTemplate(RandomSource rand) {
        return this.templates.get(rand.m_188503_(this.templates.size()));
    }

    public static abstract class SpawnerTemplateData
    implements IModifyState {
        public final ResourceLocation templateName;
        public final EntityType<?> spawnerMob;

        public SpawnerTemplateData(EntityType<?> spawnerMob, ResourceLocation templateName) {
            this.templateName = templateName;
            this.spawnerMob = spawnerMob;
        }

        public SpawnerTemplateData(EntityType<?> spawnerMob, String templateSuffix) {
            this(spawnerMob, BlueSkies.locate("cave_spawners/" + templateSuffix));
        }

        @Nullable
        public BlockState modifyState(ServerLevelAccessor world, RandomSource rand, BlockPos pos, BlockState originalState) {
            return originalState;
        }

        public void handleDataMarker(String function, BlockPos pos, WorldGenLevel world, RandomSource rand, BoundingBox bounds) {
            if (function.equals("spawner")) {
                this.placeSpawner(pos, world, rand, bounds);
            } else if (function.equals("chest")) {
                RandomizableContainerBlockEntity.m_222766_((BlockGetter)world, (RandomSource)rand, (BlockPos)pos.m_7495_(), (ResourceLocation)this.getLoot());
            }
        }

        protected void placeSpawner(BlockPos pos, WorldGenLevel world, RandomSource rand, BoundingBox bounds) {
            this.setBlockState((LevelWriter)world, pos, Blocks.f_50085_.m_49966_());
            BlockEntity blockEntity = world.m_7702_(pos);
            if (blockEntity instanceof SpawnerBlockEntity) {
                SpawnerBlockEntity tile = (SpawnerBlockEntity)blockEntity;
                tile.m_252803_(this.spawnerMob, rand);
            } else {
                BlueSkies.LOGGER.warn("{} couldn't find mob spawner at ({}, {}, {})", (Object)this.getClass().getSimpleName(), (Object)pos.m_123341_(), (Object)pos.m_123342_(), (Object)pos.m_123343_());
            }
        }

        protected void setBlockState(LevelWriter world, BlockPos pos, BlockState state) {
            world.m_7731_(pos, state, 4);
        }

        protected abstract ResourceLocation getLoot();
    }
}

